% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moves_speed.R
\name{moves_speed}
\alias{moves_speed}
\title{Return speed bins according to US/EPA MOVES model}
\usage{
moves_speed(x, net)
}
\arguments{
\item{x}{Object with class, "sf",  "data.frame", "matrix" or "numeric" with speeds
in miles/h (mph)}

\item{net}{optional  spatial dataframe of class "sf".
it is transformed to "sf".}
}
\description{
\code{speed_moves} return an object of average speed bins as defined by
US EPA MOVES. The input must be speed as miles/h (mph)
}
\examples{
{
data(net)
net$mph <- units::set_units(net$ps, "miles/h")
net$speed_bins <- moves_speed(net$mph)
head(net)
moves_speed(net["ps"])
}
}
