% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/velox_im2col.R
\name{VeloxRaster_im2col}
\alias{VeloxRaster_im2col}
\title{im2col}
\arguments{
\item{wrow}{Patch size in the y dimension.}

\item{wcol}{Patch size in the x dimension.}

\item{band}{The band to be flattened.}

\item{padval}{A padding value.}

\item{rowframe}{A non-negative integer specifying the size of the frame around
the image patches in the y dimension.}

\item{colframe}{A non-negative integer specifying the size of the frame around
the image patches in the x dimension.}

\item{rowstride}{A positive integer denoting the stride between extracted patches
in the y dimension. I.e. only every \code{rowstride}th patch is extracted.}

\item{colstride}{A positive integer denoting the stride between extracted patches
in the x dimension. I.e. only every \code{colstride}th patch is extracted.}
}
\value{
A numeric matrix with \code{(wrow+2*rowframe)*(wcol+2*colframe)} columns.
}
\description{
Creates a matrix of flattened image patches from a VeloxRaster band.
Order is left-to-right, top-to-bottom.
Note that if \code{any(c(rowframe, colframe)>0)}, the image patches are (partially) overlapping.
}
\examples{
## Make VeloxRaster
mat <- matrix(1:100, 10, 10)
vx <- velox(mat, extent=c(0,1,0,1), res=c(0.1,0.1), crs="+proj=longlat +datum=WGS84 +no_defs")
## Apply im2col
patch.mat <- vx$im2col(wrow=2, wcol=2, band=1, padval=0,
                       rowframe=1, colframe=1, rowstride=2, colstride=2)
dim(patch.mat)

}

