% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_hierarchically_sparse_data.R
\name{estimate.hier.sparsity.param}
\alias{estimate.hier.sparsity.param}
\title{function to estimate the hierarchical sparsity parameter for a desired level of sparsity for simulated hierarchical coefficients}
\usage{
estimate.hier.sparsity.param(
  ncats,
  nvars,
  avg.hier.zeros = 0.3,
  nsims = 150,
  effect.size.max = 0.5,
  misspecification.prop = 0
)
}
\arguments{
\item{ncats}{number of categories to stratify on}

\item{nvars}{number of variables}

\item{avg.hier.zeros}{desired percent of zero variables among the variables with hierarchical zero patterns.}

\item{nsims}{number of simulations to estimate the average sparsity. A larger number will be more accurate but take much longer.}

\item{effect.size.max}{maximum magnitude of the true effect sizes}

\item{misspecification.prop}{proportion of variables with hierarchical missingness misspecified}
}
\description{
function to estimate the hierarchical sparsity parameter for a desired level of sparsity for simulated hierarchical coefficients
}
\examples{
set.seed(123)


# estimate hier.sparsity.param for 0.15 total proportion of nonzero variables
# among vars with hierarchical zero patterns
\dontrun{
hsp <- estimate.hier.sparsity.param(ncats = 3, nvars = 25, avg.hier.zeros = 0.15, nsims = 100)
}
# the above results in the following value
hsp <- 0.6341772

# check that this does indeed achieve the desired level of sparsity
mean(replicate(100, mean(genHierSparseBeta(ncats = 3, 
                           nvars = 25, hier.sparsity.param = hsp) != 0)  ))

sparseBeta <- genHierSparseBeta(ncats = 3, nvars = 25, hier.sparsity.param = hsp)


\dontrun{
hsp2 <- estimate.hier.sparsity.param(ncats = 2, nvars = 100, 
                        avg.hier.zeros = 0.30, nsims = 50) # 0.5778425
hsp3 <- estimate.hier.sparsity.param(ncats = 3, nvars = 100, 
                        avg.hier.zeros = 0.30, nsims = 50) # 0.4336312
hsp4 <- estimate.hier.sparsity.param(ncats = 4, nvars = 100, 
                        avg.hier.zeros = 0.30, nsims = 50) # 0.2670061
hsp5 <- estimate.hier.sparsity.param(ncats = 5, nvars = 100, 
                        avg.hier.zeros = 0.30, nsims = 50) # 0.146682
}
# 0.07551241 for hsp6

}
