% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/versionsort.R
\name{ver_order}
\alias{ver_order}
\title{Order version codes}
\usage{
ver_order(x)
}
\arguments{
\item{x}{\code{\link[=character]{character()}}\cr
A vector of version codes that start with a number (as in "1.5.0"), i.e.
without initial "v" (as in "v1.5.0").}
}
\value{
An integer vector (for details see \code{\link[base]{order}}).
}
\description{
\code{ver_order()} returns the permutation that rearranges a vector
of version codes alphanumerically.
}
\examples{
version_codes <- c("1.5-0", "1.4-1", "0.0.0.9000", "1.4-0a", "1.4-0")
ver_order(version_codes)
# The line below is the same as ver_sort(version_codes)
version_codes[ver_order(version_codes)]

}
\seealso{
\code{\link{ver_sort}()}
}
