% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vimp_ci.R
\name{vimp_ci}
\alias{vimp_ci}
\title{Confidence intervals for variable importance}
\usage{
vimp_ci(est, se, level = 0.95)
}
\arguments{
\item{est}{estimate of variable importance from a call to \code{variableImportance}.}

\item{se}{estimate of the standard error of \code{est}, from a call to \code{variableImportanceSE}}

\item{level}{confidence interval type (defaults to 0.95).}
}
\value{
The Wald-based confidence interval for the true importance of the given group of left-out covariates.
}
\description{
Compute confidence intervals for the true variable importance parameter interpreted as the proportion of variability explained by including a group of covariates in the estimation technique.
}
\details{
See the paper by Williamson, Gilbert, Simon, and Carone for more
details on the mathematics behind this function and the definition of the parameter of interest.
}
