% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two_validation_set_cv.R
\name{two_validation_set_cv}
\alias{two_validation_set_cv}
\title{V-fold cross-validation with two validation sets}
\usage{
two_validation_set_cv(n, V)
}
\arguments{
\item{n}{the sample size}

\item{V}{the number of folds}
}
\value{
an n by V matrix containing the train/test set 1/test set 2 data for each fold.
}
\description{
Set up V-fold cross-validation, where rather than the usual train/test split
for each fold, now there are two test datasets. In practice, this means that
each datum is in the training data V - 2 times, in the first test set once,
and in the second test set once.
}
\details{
This method is only different from V-fold cross-validation by how much data is used in the training sample, 
and the fact that two validation samples are needed. Specifically, in two-validation-set V-fold CV, n/V fewer observations are used in training than in V-fold CV. These n/V observations are used in the second validation set.
}
\examples{
n <- 100
V <- 5
## set up two-validation-set 5-fold CV
folds <- two_validation_set_cv(n, V)

}
