% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_sl.R
\name{run_sl}
\alias{run_sl}
\title{Run a Super Learner for the provided subset of features}
\usage{
run_sl(Y, X, V, SL.library, s, folds, ...)
}
\arguments{
\item{Y}{the outcome}

\item{X}{the covariates}

\item{V}{the number of folds}

\item{SL.library}{the library of candidate learners}

\item{s}{the subset of interest}

\item{folds}{the CV folds}

\item{...}{other arguments to Super Learner}
}
\value{
a list of length V, with the results of predicting on the hold-out data for each v in 1 through V
}
\description{
Run a Super Learner for the provided subset of features.
}
\examples{
\donttest{
library("SuperLearner")
library("gam")
n <- 100
p <- 2
## generate the data
x <- data.frame(replicate(p, stats::runif(n, -5, 5)))

## apply the function to the x's
smooth <- (x[,1]/5)^2*(x[,1]+7)/5 + (x[,2]/3)^2

## generate Y ~ Normal (smooth, 1)
y <- as.matrix(smooth + stats::rnorm(n, 0, 1))

## set up a library for SuperLearner
learners <- c("SL.mean", "SL.gam")
## run the Super Learner
set.seed(4747)
fitted_lst <- run_sl(y, x, V = 5, SL.library = learners, s = )
}

}
