% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_formula.R
\name{parse_formula}
\alias{parse_formula}
\title{Parse an R formula to generate a dataframe where the response and explanatory variables including interaction terms are explicitly written into columns}
\usage{
parse_formula(formula, data=NULL, IMPUTE=FALSE, IMPUTE_METHOD=mean)
}
\arguments{
\item{formula}{R's compact symbolic form to represent linear models with fixed additive and interaction effects (See ?formula for more information) [mandatory]}

\item{data}{data.frame containing the response and explanatory variables which forms the formula above [default=NULL]}

\item{IMPUTE}{logical referring to whether impute missing and infinite datapoints [default=FALSE]}

\item{IMPUTE_METHOD}{imputation function to use [default=mean]}
}
\value{
Dataframe where the response and explanatory variables including interaction terms if applicable are explicitly written into columns

All explanatory variables are converted into categorical variables
}
\description{
Parse an R formula to generate a dataframe where the response and explanatory variables including interaction terms are explicitly written into columns
}
\examples{
x1 = rep(rep(rep(c(1:5), each=5), times=5), times=5)
x2 = rep(rep(letters[6:10], each=5*5), times=5)
x3 = rep(letters[11:15], each=5*5*5)
y = rep(1:5, each=5*5*5) + rnorm(rep(1:5, each=5), length(x1))
data = data.frame(x1, x2, x3, y)
formula = y ~ x1 + x2 + x3 + (x2:x3)
DF = parse_formula(formula=formula, data=data)

}
