% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vi_pdp.R
\name{vi_pdp}
\alias{vi_pdp}
\alias{vi_pdp.default}
\title{PDP-Based Variable Importance}
\usage{
vi_pdp(object, ...)

\method{vi_pdp}{default}(object, feature_names, FUN = NULL,
  var_fun = NULL, ...)
}
\arguments{
\item{object}{A fitted model object (e.g., a \code{"randomForest"} object).}

\item{...}{Additional optional arguments to be passed onto
\code{\link[pdp]{partial}}.}

\item{feature_names}{Character string giving the names of the predictor
variables (i.e., features) of interest.}

\item{FUN}{Deprecated. Use \code{var_fun} instead.}

\item{var_fun}{List with two components, \code{"cat"} and \code{"con"},
containing the functions to use to quantify the variability of the feature
effects (e.g., partial dependence values) for categorical and continuous
features, respectively. If \code{NULL}, the standard deviation is used for
continuous features. For categorical features, the range statistic is used
(i.e., (max - min) / 4). Only used when \code{method = "pdp"} or
\code{method = "ice"}.}
}
\value{
A tidy data frame (i.e., a \code{"tibble"} object) with two columns,
\code{Variable} and \code{Importance}, containing the variable name and its
associated importance score, respectively.
}
\description{
Compute PDP-based VIscores for the predictors in a model.
See details below.
}
\details{
This approach to computing VI scores is based on quantifying the
relative "flatness" of the \emph{partial dependence plot} (PDP) of each
feature. It is model-agnostic and can be applied to any supervised learning
algorithm. By default, relative "flatness" is defined by computing the
standard deviation of the y-axis values for each PDP for numeric features;
for categorical features, the default is to use range divided by 4. This can
be changed via the `var_fun` argument. See
\href{https://arxiv.org/abs/1805.04755}{Greenwell et al. (2018)} for details
and additional examples.

#' @references
Greenwell, B. M., Boehmke, B. C., and McCarthy, A. J. A Simple
and Effective Model-Based Variable Importance Measure. arXiv preprint
arXiv:1805.04755 (2018).
#' @rdname vi_pdp
}
