% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/violinPoint.R
\name{aveWithArgs}
\alias{aveWithArgs}
\title{the ave() function but with arguments passed to FUN}
\usage{
aveWithArgs(x, y, FUN = mean, ...)
}
\arguments{
\item{x}{a vector to apply FUN to}

\item{y}{a vector or list of vectors of grouping variables all of the same length as \code{x}}

\item{FUN}{function to apply for each factor level combination.}

\item{...}{additional arguments to \code{FUN}}
}
\value{
A numeric vector of the same length as \code{x} where an each element contains the output from \code{FUN} after \code{FUN} was applied on the corresponding subgroup for that element (repeated if necessary within a subgroup).
}
\description{
A function is applied to subsets of \code{x} where each subset consist of those observations with the same groupings in \code{y}
}
\examples{
aveWithArgs(1:10,rep(1:5,2))
aveWithArgs(c(1:9,NA),rep(1:5,2),max,na.rm=TRUE)
}
\seealso{
\code{\link{ave}}
}

