% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visLegend.R
\name{visLegend}
\alias{visLegend}
\title{Add a legend on a visNetwork object}
\usage{
visLegend(graph, enabled = TRUE, useGroups = TRUE, addNodes = NULL,
  addEdges = NULL, width = 0.2, position = "left", main = NULL)
}
\arguments{
\item{graph}{: a visNetwork object}

\item{enabled}{: Boolean. Default to TRUE.}

\item{useGroups}{: use groups options in legend ? Default to TRUE.}

\item{addNodes}{: a data.frame or a list for adding custom node(s)}

\item{addEdges}{: a data.frame or a list for adding custom edges(s)}

\item{width}{: Number, in [0,...,1]. Default to 0.2}

\item{position}{: one of "left" (Default) or "right"}

\item{main}{: For add a title. Character or a named list.
\itemize{
 \item{"text"}{ : Character. Title.}
 \item{"style"}{ : Optional. Character. HTML style of title. Default to 'font-family:Georgia, Times New Roman, Times, serif;font-weight:bold;font-size:14px;text-align:center;'.}
}}
}
\description{
Add a legend on a visNetwork object
}
\examples{

# minimal example
nodes <- data.frame(id = 1:3, group = c("B", "A", "B"))
edges <- data.frame(from = c(1,2), to = c(2,3))

# default, on group
visNetwork(nodes, edges) \%>\%
  visGroups(groupname = "A", color = "red") \%>\%
  visGroups(groupname = "B", color = "lightblue") \%>\%
  visLegend()
  
# default, on group, adjust width + change position
visNetwork(nodes, edges) \%>\%
  visGroups(groupname = "A", color = "red") \%>\%
  visGroups(groupname = "B", color = "lightblue") \%>\%
  visLegend(width = 0.05, position = "right")

# add a title
visNetwork(nodes, edges) \%>\%
  visGroups(groupname = "A", color = "red") \%>\%
  visGroups(groupname = "B", color = "lightblue") \%>\%
  visLegend(main = "Legend")
  
visNetwork(nodes, edges) \%>\%
  visGroups(groupname = "A", color = "red") \%>\%
  visGroups(groupname = "B", color = "lightblue") \%>\%
  visLegend(main = list(text = "Custom Legend",
 style = "font-family:Comic Sans MS;color:#ff0000;font-size:12px;text-align:center;"))
   
# passing custom nodes and/or edges
lnodes <- data.frame(label = c("Group A", "Group B"), 
 shape = c( "ellipse"), color = c("red", "lightblue"),
 title = "Informations", id = 1:2) 
   
visNetwork(nodes, edges) \%>\%
  visGroups(groupname = "A", color = "red") \%>\%
  visGroups(groupname = "B", color = "lightblue") \%>\%
  visLegend(addNodes = lnodes, useGroups = FALSE)
  
ledges <- data.frame(color = c("lightblue", "red"), 
 label = c("reverse", "depends"), arrows =c("to", "from")) 
 
visNetwork(nodes, edges) \%>\%
  visGroups(groupname = "A", color = "lightblue") \%>\%
  visGroups(groupname = "B", color = "red") \%>\%
  visLegend(addEdges = ledges)    
  
# for more complex option, you can use a list(of list...)
 # or a data.frame with specific notaion

nodes <- data.frame(id = 1:3, group = c("B", "A", "B"))
edges <- data.frame(from = c(1,2), to = c(2,3))

# using a list
visNetwork(nodes, edges) \%>\%
 visGroups(groupname = "A", shape = "icon", icon = list(code = "f0c0", size = 75)) \%>\%
 visGroups(groupname = "B", shape = "icon", icon = list(code = "f007", color = "red")) \%>\%
 addFontAwesome() \%>\%
 visLegend(addNodes = list(
  list(label = "Group", shape = "icon", icon = list(code = "f0c0", size = 25)),
  list(label = "User", shape = "icon", icon = list(code = "f007", size = 50, color = "red"))
 ),
 addEdges = data.frame(label = "link"), useGroups = FALSE)   
 
# using a data.frame
addNodes <- data.frame(label = c("Group", "User"), shape = "icon",
 icon.code = c("f0c0", "f007"), icon.size = c(25, 50), icon.color = c(NA, "red"))
 
visNetwork(nodes, edges) \%>\%
 visGroups(groupname = "A", shape = "icon", icon = list(code = "f0c0", size = 75)) \%>\%
 visGroups(groupname = "B", shape = "icon", icon = list(code = "f007", color = "red")) \%>\%
 addFontAwesome() \%>\%
 visLegend(addNodes = addNodes,
   addEdges = data.frame(label = "link"), useGroups = FALSE)   
   
}
\references{
See online documentation \url{http://datastorm-open.github.io/visNetwork/}
}
\seealso{
\link{visNodes} for nodes options, \link{visEdges} for edges options, \link{visGroups} for groups options, 
\link{visLegend} for adding legend, \link{visOptions} for custom option, \link{visLayout} & \link{visHierarchicalLayout} for layout, 
\link{visPhysics} for control physics, \link{visInteraction} for interaction, \link{visNetworkProxy} & \link{visFocus} & \link{visFit} for animation within shiny,
\link{visDocumentation}, \link{visEvents}, \link{visConfigure} ...
}

