% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visit_simu.R
\name{vtScenario}
\alias{vtScenario}
\title{Set simulation scenario}
\usage{
vtScenario(tox = c(0.05, 0.05, 0.08), res = c(0.2, 0.3, 0.5),
  rho = 1)
}
\arguments{
\item{tox}{Vector of marginal DLT risk rates for all levels}

\item{res}{Vector of marginal immune response rates for all levels}

\item{rho}{Vector of odds ratio for all levels. If length of \code{rho} is
shorter than the length of \code{tox} or \code{res}, vector \code{rho} is
repeated to have the same length as \code{tox} and \code{res}.}
}
\value{
a \code{VTTRUEPS} object containing all \eqn{\theta}'s in a matrix
    with its number of rows equaling the number of dose levels and its number
    of columns being 4.
}
\description{
Simulation function. Get true \eqn{\theta}'s using marginal probabilities and
odds ratio \eqn{\rho} for all dose levels.
}
\details{
The calculation is as following. If \eqn{\rho = 1}, then \eqn{\theta_{11} =
pq}, \eqn{\theta_{01} = (1-p)q}, \eqn{\theta_{10} = p(1-q)}, and
\eqn{\theta_{00} = (1-p)(1-q)}. Otherwise, \eqn{ \theta_{11} = -(\sqrt{A+B}},
\eqn{\theta_{01} = q-\theta_{11}}, \eqn{\theta_{10} = p-\theta_{11}}, and
\eqn{\theta_{00} = \theta_{01}\theta_{10}\rho/\theta_{11}}, where
\eqn{A=(p+q-p \rho-q\rho-1)^2-4(\rho-1)pq\rho)} and
\eqn{B=(p+q-p\rho-q\rho-1))/2/(\rho-1)}.
}
\examples{
 rst.sce <- vtScenario(tox=c(0.05, 0.05, 0.08), res=c(0.2, 0.3, 0.5), rho=1)

}
