% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brief.R, R/detailed.R
\name{brief_entries}
\alias{brief_entries}
\alias{cv_entries}
\alias{detailed_entries}
\title{CV entries}
\usage{
brief_entries(data, what, when, with, .protect = TRUE)

detailed_entries(data, what, when, with, where, why, .protect = TRUE)
}
\arguments{
\item{data}{A \code{data.frame} or \code{tibble}.}

\item{what}{The primary value of the entry (such as workplace title or degree).}

\item{when}{The time of the entry (such as the period spent in the role).}

\item{with}{The company or organisation.}

\item{.protect}{When TRUE, inputs to the previous arguments will be protected
from being parsed as LaTeX code.}

\item{where}{The location of the entry.}

\item{why}{Any additional information, to be included as dot points. Multiple
dot points can be provided via a list column.
Alternatively, if the same \code{what}, \code{when}, \code{with}, and \code{where} combinations
are found in multiple rows, the \code{why} entries of these rows will be combined
into a list.}
}
\description{
This function accepts a data object (such as a tibble) and formats the output
into a suitable format for the template used. The inputs can also involve
further calculations, which will be done using the provided data.
}
\details{
All non-data inputs are optional, and will result in an empty space if omitted.
}
\examples{
packages_used <- tibble::tribble(
  ~ package, ~ date, ~ language, ~ timezone, ~ details,
  "vitae", Sys.Date(), "R", Sys.timezone(), c("Making my CV with vitae.", "Multiple why entries."),
  "rmarkdown", Sys.Date()-10, "R", Sys.timezone(), "Writing reproducible, dynamic reports using R."
)
packages_used \%>\%
  detailed_entries(what = package, when = date, with = language, where = timezone, why = details)

}
