% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth.R
\name{smooth_spline}
\alias{smooth_spline}
\alias{smooth_mortality}
\alias{smooth_fertility}
\alias{smooth_loess}
\title{Functions to smooth demographic data}
\usage{
smooth_spline(.data, .var, age_spacing = 1, k = -1)

smooth_mortality(.data, .var, age_spacing = 1, b = 65, power = 0.4, k = 30)

smooth_fertility(.data, .var, age_spacing = 1, lambda = 1e-10)

smooth_loess(.data, .var, age_spacing = 1, span = 0.2)
}
\arguments{
\item{.data}{A vital object}

\item{.var}{name of variable to smooth}

\item{age_spacing}{Spacing between ages for smoothed vital. Default is 1.}

\item{k}{Number of knots to use for penalized regression spline estimate.}

\item{b}{Lower age for monotonicity. Above this, the smooth curve is assumed to be monotonically increasing.}

\item{power}{Power transformation for age variable before smoothing. Default is 0.4 (for mortality data).}

\item{lambda}{Penalty for constrained regression spline.}

\item{span}{Span for loess smooth.}
}
\value{
vital with added columns containing smoothed values and their standard errors
}
\description{
These smoothing functions allow smoothing of a variable in a vital object.
The vital object is returned along with some additional columns containing
information about the smoothed variable: usually \code{.smooth} containing the
smoothed values, and \code{.smooth_se} containing the corresponding standard errors.
}
\details{
\code{smooth_mortality()} use penalized regression splines applied to log mortality
with a monotonicity constraint above age \code{b}. The methodology is based on Wood (1994).
\code{smooth_fertility()} uses weighted regression B-splines with a concavity constraint,
based on He and Ng (1999). The function \code{smooth_loess()} uses locally quadratic
regression, while \code{smooth_spline()} uses penalized regression splines.
}
\examples{
library(dplyr)
aus_mortality |>
	filter(State == "Victoria", Sex == "female", Year > 2000) |>
	smooth_mortality(Mortality)
aus_fertility |>
 filter(Year > 2000) |>
	smooth_fertility(Fertility)
}
\references{
Hyndman, R.J., and Ullah, S. (2007) Robust forecasting of
mortality and fertility rates: a functional data approach.
\emph{Computational Statistics & Data Analysis}, 51, 4942-4956.
\url{https://robjhyndman.com/publications/funcfor/}
}
\author{
Rob J Hyndman
}
\keyword{smooth}
