% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/totals_bind.R
\name{totals_bind}
\alias{totals_bind}
\title{Row-bind an identical data frame for computing grouped totals}
\usage{
totals_bind(data, target_col, target_value = "Total")
}
\arguments{
\item{data}{data frame}

\item{target_col}{Character value of the column in which to impute \code{"Total"}.
This is usually the intended grouping column.}

\item{target_value}{Character value to impute in the new data frame to
row-bind. Defaults to \code{"Total"}.}
}
\value{
data frame with twice the number of rows of the input data frame, where half
of those rows will have the \code{target_col} column imputed with the value from
\code{target_value}.
}
\description{
Row-bind an identical data frame and impute a specific
column with the \code{target_value}, which defaults as "Total". The purpose of
this is to enable to creation of summary tables with a calculated "Total"
row. See example below on usage.
}
\examples{
pq_data \%>\%
  totals_bind(target_col = "LevelDesignation", target_value = "Total") \%>\%
  create_bar(hrvar = "LevelDesignation", metric = "Email_hours", return = "table")

}
\seealso{
Other Support: 
\code{\link{camel_clean}()},
\code{\link{check_inputs}()},
\code{\link{cut_hour}()},
\code{\link{extract_date_range}()},
\code{\link{extract_hr}()},
\code{\link{heat_colours}()},
\code{\link{is_date_format}()},
\code{\link{maxmin}()},
\code{\link{rgb2hex}()},
\code{\link{totals_col}()},
\code{\link{tstamp}()},
\code{\link{us_to_space}()},
\code{\link{wrap}()}
}
\concept{Support}
