% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_query.R
\name{prep_query}
\alias{prep_query}
\title{Prepare variable names and types in query data frame for analysis}
\usage{
prep_query(data, convert_date = TRUE, date_format = "\%m/\%d/\%Y")
}
\arguments{
\item{data}{A Standard Person Query dataset in the form of a data frame. You
should pass the data frame that is read into R using \emph{any other method}
other than \code{import_query()}, as \code{import_query()} automatically performs the
same variable operations.}

\item{convert_date}{Logical. Defaults to \code{TRUE}. When set to \code{TRUE}, any
variable that matches true with \code{is_date_format()} gets converted to a Date
variable. When set to \code{FALSE}, this step is skipped.}

\item{date_format}{String specifying the date format for converting any
variable that may be a date to a Date variable. Defaults to \code{"\%m/\%d/\%Y"}.}
}
\value{
A \code{tibble} with the cleaned data frame is returned.
}
\description{
For applying to data frames that are read into R using \emph{any
other method} other than \code{import_query()}, this function cleans variable
names by replacing special characters and converting the relevant variable
types so that they are compatible with the rest of the functions in
\strong{vivainsights}.
}
\section{Examples}{


The following shows when and how to use \code{prep_query()}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ pq_df <- read.csv("path_to_query.csv")
 cleaned_df <- pq_df |> prep_query()
}\if{html}{\out{</div>}}

You can then run checks to see that the variables are of the correct type:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dplyr::glimpse(cleaned_df)
}\if{html}{\out{</div>}}
}

\seealso{
Other Import and Export: 
\code{\link{copy_df}()},
\code{\link{create_dt}()},
\code{\link{export}()},
\code{\link{import_query}()}
}
\concept{Import and Export}
