% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dNdS_segment.R
\name{dNdS_segment}
\alias{dNdS_segment}
\title{dNdS_segment}
\usage{
dNdS_segment(annotation_df, SPLICEFORMS)
}
\arguments{
\item{annotation_df}{A rearranged, filtered, and annotated vcf dataframe - must be for amino-acid specific calculations, cannot be the same as the dataframe used for SNP calculations}

\item{SPLICEFORMS}{A character vector of isoform names}
}
\value{
A plot showing the dN/dS ratio for each splice form (rather than segment) for each sample
}
\description{
Reads in a dataframe that has been arranged (arrange_data), filtered (filter_variants), and annotated (prepare_annotations), calculates dNdS, and outputs plots
}
\examples{
# Sample Data
head(example_filtered_SNV_df)
dim(example_filtered_SNV_df)

# Plot showing the dN/dS ratio for each splice form
SPLICEFORMS = c("H1N1_PB2.1", "H1N1_PB1.1","H1N1_NS.2")
dNdS_segment(example_filtered_SNV_df, SPLICEFORMS)
}
