% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdpZen.R
\name{pdpZen}
\alias{pdpZen}
\title{Create a zenplot displaying partial dependence values.}
\usage{
pdpZen(
  data,
  fit,
  response,
  zpath = NULL,
  pal = rev(RColorBrewer::brewer.pal(11, "RdYlBu")),
  fitlims = "pdp",
  gridSize = 10,
  nmax = 500,
  class = 1,
  comboImage = FALSE,
  rug = TRUE,
  predictFun = NULL,
  convexHull = FALSE,
  ...
)
}
\arguments{
\item{data}{Data frame used for fit}

\item{fit}{A supervised machine learning model, which understands condvis2::CVpredict}

\item{response}{The name of the response for the fit}

\item{zpath}{Plot shows consecutive pairs of these variables. Defaults to all variables other than response.
Recommend constructing zpath witn \code{calcZpath}.}

\item{pal}{A vector of colors to show predictions, for use with scale_fill_gradientn}

\item{fitlims}{Specifies the fit range for the color map. Options are a numeric vector of length 2,
"pdp" (default), in which cases limits are calculated from the pdp, or "all", when limits are calculated from the observations and pdp
predictions outside fitlims are squished on the color scale.}

\item{gridSize}{The size of the grid for evaluating the predictions.}

\item{nmax}{Uses sample of nmax data rows for the pdp. Use all rows if NULL.}

\item{class}{Category for classification, a factor level, or a number indicating which factor level.}

\item{comboImage}{If TRUE  draws pdp for mixed variable plots as an image, otherwise an interaction plot.}

\item{rug}{If TRUE adds rugs for the data to the pdp plots}

\item{predictFun}{Function of (fit, data) to extract numeric predictions from fit. Uses condvis2::CVpredict by default, which works for many fit classes.}

\item{convexHull}{If TRUE, then the convex hull is computed and any points outside the convex hull are removed.}

\item{...}{passed on to zenplot}
}
\value{
A zenplot of partial dependence values.
}
\description{
Constructs a zigzag expanded navigation plot (zenplot) displaying partial dependence values.
}
\examples{
\dontrun{
# To use this function, install zenplots and graph from Bioconductor.
if (!requireNamespace("graph", quietly = TRUE)) {
  install.packages("BiocManager")
  BiocManager::install("graph")
}
install.packages("zenplots")

library(MASS)
library(ranger)
Boston1 <- Boston
Boston1$chas <- factor(Boston1$chas)
rf <- ranger(medv ~ ., data = Boston1)
pdpZen(Boston1[1:30, ], rf, response = "medv", zpath = names(Boston1)[1:4], comboImage = T)
# Find the top variables in rf
set.seed(123)
viv <- vivi(Boston1, rf, "medv", nmax = 30) # use 30 rows, for speed
pdpZen(Boston1, rf, response = "medv", zpath = rownames(viv)[1:4], comboImage = T)
zpath <- zPath(viv, cutoff = .2) # find plots whose interaction score exceeds .2
pdpZen(Boston1, rf, response = "medv", zpath = zpath, comboImage = T)
}
}
