% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polar_grid.R
\name{polar_grid}
\alias{polar_grid}
\title{Grid required for 3D volcano plot and 2D radial plots}
\usage{
polar_grid(
  r_vector = NULL,
  z_vector = NULL,
  r_axis_ticks = NULL,
  z_axis_ticks = NULL,
  axis_angle = 5/6,
  n_spokes = 12,
  axes_from_origin = TRUE,
  ...
)
}
\arguments{
\item{r_vector}{An optional numerical vector for the  radial coordinates.
This is used to calculate breaks on the r axis using
\code{\link[base]{pretty}}. If this is NULL the r_axis_ticks are used as
breaks.}

\item{z_vector}{An optional numerical vector for the z coordinates.
This is used to calculate breaks on the z axis using \code{pretty}. If this
is NULL the z_axis_ticks are used as breaks.}

\item{r_axis_ticks}{A numerical vector of breaks for the radial axis (used
if r_vector is NULL).}

\item{z_axis_ticks}{A numerical vector of breaks for the z axis (used
if z_vector is NULL).}

\item{axis_angle}{angle in radians to position the radial axis
(default = 5/6)}

\item{n_spokes}{the number of outward spokes to be plotted (default = 12)}

\item{axes_from_origin}{Whether the axis should start at 0 or the first
break (default = TRUE)}

\item{...}{optional parameters for \code{\link[base]{pretty}} on the r axis}
}
\value{
Returns an S4 grid object containing:
\itemize{
\item{'polar_grid'} The coordinates for a radial grid
\item{'axes'} The axes features for 'plotly'
\item{'axis_labels'} The axis labels
\item{'r'} The grid radius
\item{'z'} The grid height
\item{'text_coords'} The coordinates for text labels
\item{'n_r_breaks'} The number of ticks on the r axis
\item{'n_r_breaks'} The number of ticks on the z axis
}
}
\description{
Generates a cylindrical grid of the appropriate dimensions for a 3D volcano
plot
}
\examples{
data(example_data)
syn_polar <- polar_coords(outcome = syn_example_meta$Pathotype,
                          data = t(syn_example_rld))

grid <- polar_grid(r_vector=syn_polar@df[[1]]$r,
           z_vector=NULL,
           r_axis_ticks = NULL,
           z_axis_ticks = c(0, 8, 16, 32),
           n_spokes = 4)
}
\references{
Lewis, Myles J., et al. (2019).
\href{https://pubmed.ncbi.nlm.nih.gov/31461658/}{
Molecular portraits of early rheumatoid arthritis identify clinical and
treatment response phenotypes.}
\emph{Cell reports}, \strong{28}:9
}
\keyword{dplot}
\keyword{htest}
\keyword{manip}
