% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{copula1}
\alias{copula1}
\title{Construct a copula using uniform sampling from the unit simplex}
\usage{
copula1(h1, h2, numSlices, N)
}
\arguments{
\item{h1}{A \eqn{d}-dimensional vector that describes the direction of the first family of parallel hyperplanes.}

\item{h2}{A \eqn{d}-dimensional vector that describes the direction of the second family of parallel hyperplanes.}

\item{numSlices}{The number of the slices for the copula. Default value is 100.}

\item{N}{The number of points to sample. Default value is \eqn{4\cdot 10^6}.}
}
\value{
A \eqn{numSlices\times numSlices} numerical matrix that corresponds to a copula.
}
\description{
Given two families of parallel hyperplanes intersecting the canonical simplex, this function uniformly samples from the canonical simplex and construct an approximation of the bivariate probability distribution, called copula.
}
\examples{
# compute a copula for two random families of parallel hyperplanes
h1 = runif(n = 10, min = 1, max = 1000)
h1 = h1 / 1000
h2=runif(n = 10, min = 1, max = 1000)
h2 = h2 / 1000
cop = copula1(h1=h1, h2=h2, numSlices = 10, N = 100000)
}
\references{
\cite{L. Cales, A. Chalkis, I.Z. Emiris, V. Fisikopoulos,
\dQuote{Practical volume computation of structured convex bodies, and an application to modeling portfolio dependencies and financial crises,} \emph{Proc. of Symposium on Computational Geometry, Budapest, Hungary,} 2018.}
}
