% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{write_sdpa_format_file}
\alias{write_sdpa_format_file}
\title{Write a SDPA format file}
\usage{
write_sdpa_format_file(spectrahedron, objective_function, output_file)
}
\arguments{
\item{spectrahedron}{A spectrahedron in n dimensions; must be an object of class Spectrahedron}

\item{objective_function}{A numerical vector of length n}

\item{output_file}{Name of the output file}
}
\description{
Outputs a spectrahedron (the matrices defining a linear matrix inequality) and a vector (the objective function)
to a SDPA format file.
}
\examples{
\donttest{
A0 = matrix(c(-1,0,0,0,-2,1,0,1,-2), nrow=3, ncol=3, byrow = TRUE)
A1 = matrix(c(-1,0,0,0,0,1,0,1,0), nrow=3, ncol=3, byrow = TRUE)
A2 = matrix(c(0,0,-1,0,0,0,-1,0,0), nrow=3, ncol=3, byrow = TRUE)
lmi = list(A0, A1, A2)
S = Spectrahedron(matrices = lmi)
objFunction = c(1,1)
write_sdpa_format_file(S, objFunction, "output.txt")
}
}
