% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcn_network.R
\name{tcn_network}
\alias{tcn_network}
\title{Generate network from conversation tweets}
\usage{
tcn_network(data = NULL, type = "actor")
}
\arguments{
\item{data}{Named list. Dataframes of threaded conversation tweets and users collected by get_threads function.}

\item{type}{Character string. Type of network to generate, either "actor" or "activity". Default is "actor".}
}
\value{
Named list of dataframes for network nodes and edges.
}
\description{
Creates the nodes and edges for a Twitter conversation network. An "activity" type network with tweets as nodes, or
an "actor" type with users as nodes can be created.
}
\examples{
\dontrun{
# generate twitter conversation network
network <- tcn_network(tweets, "activity")

# network nodes and edges
network$nodes
network$edges
}

}
