% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EC_functions.R
\name{bin_cast}
\alias{bin_cast}
\title{Bin vpr data}
\usage{
bin_cast(ctd_roi_oce, imageVolume, binSize, rev = FALSE)
}
\arguments{
\item{ctd_roi_oce}{\code{oce} ctd format VPR data from \code{\link{vpr_oce_create}}}

\item{imageVolume}{the volume of VPR images used for calculating concentrations (mm^3)}

\item{binSize}{passed to \code{\link{bin_calculate}}, determines size of depth bins over which data is averaged}

\item{rev}{logical value,passed to \code{\link{bin_calculate}} if TRUE, binning will begin at bottom of each cast,
this controls data loss due to uneven binning over depth. If bins begin at
bottom, small amounts of data may be lost at the surface of each cast, if
binning begins at surface (rev = FALSE), small amounts of data may be lost
at bottom of each cast}
}
\value{
A dataframe of depth averaged bins of VPR data over an entire cast with calculated concentration values
}
\description{
Formats \code{oce} style VPR data into depth averaged bins using \code{\link{ctd_cast}} and \code{\link{bin_calculate}}
This function is used inside \code{\link{concentration_category}}
}
\details{
Image volume calculations can change based on optical setting of VPR as well as autodeck setting used to process images
For IML2018051 (S2) image volume was calculated as 108155 mm^3 by seascan (6.6 cubic inches)
For COR2019002 S2 image volume was calculated as 83663 mm^3 and S3 image volume was calculated as 366082 mm^3
}
