% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EC_functions.R
\name{concentration_category}
\alias{concentration_category}
\title{Binned concentrations}
\usage{
concentration_category(data, taxa, binSize, imageVolume, rev = FALSE)
}
\arguments{
\item{data}{dataframe produced by processing internal to vpr_roi_concentration}

\item{taxa}{name of taxa isolated}

\item{binSize}{passed to \code{\link{bin_calculate}}, determines size of depth bins over which data is averaged}

\item{imageVolume}{the volume of VPR images used for calculating concentrations (mm^3)}

\item{rev}{Logical value defining direction of binning, FALSE - bins will be
calculated from surface to bottom, TRUE- bins will be calculated bottom to
surface}
}
\description{
This function produces depth binned concentrations for a specified taxa. Similar to \code{\link{bin_cast}} but calculates concentrations for only one taxa.
Used inside \code{\link{vpr_roi_concentration}}
}
\details{
Image volume calculations can change based on optical setting of VPR as well as autodeck setting used to process images
For IML2018051 (S2) image volume was calculated as 108155 mm^3 by seascan (6.6 cubic inches)
For COR2019002 S2 image volume was calculated as 83663 mm^3 and S3 image volume was calculated as 366082 mm^3
}
\author{
E. Chisholm
}
