% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predictive.plot.R
\name{predictive.plot}
\alias{predictive.plot}
\title{Plot Predictive Interval for Categorical Genotype/Phenotype Groups}
\usage{
predictive.plot(cross, mean.formula, var.formula, marker.name, phen.name,
  title = paste("Predictive of", response.phen, "from", phen.name, "and",
  marker.name), title.cex = 1, genotype.plotting.names = c("AA", "AB",
  "BB"), ribbon.width = 10, xlim = NA, ylim = NA)
}
\arguments{
\item{cross}{The cross object to be plotted}

\item{mean.formula}{The formula that describes the response, and the covariates and genetic effects that influence it.
  The left hand side of the ~ must be a single phenotype that is in the cross.
  The right hand side must use only phenotypes thata are in the cross, markers that are in the cross,
  and the special terms: mean.QTL.add (additive effect on the mean) and mean.QTL.dom (dominance deviation from additive on the mean).}

\item{var.formula}{The formula that describes the covariates and the genetic effects that influence residual (environmental) variation.
  There should be nothing on the left of the ~ (Inferred to be residual variation).
  The right hand side must use only phenotypes thata are in the cross, markers that are in the cross,
  and the special terms: var.QTL.add (additive effect on the variance) and var.QTL.dom (dominance deviation from additive on the variance).}

\item{marker.name}{The name of the marker the effects of which we want to investigate and visualize.}

\item{phen.name}{The categorical phenotype the effects of which we want to investigate and visualize.}

\item{title}{Optionally, title for the plot.  Defaults to 'Predictive of [response phenotype] from
  [predictive phenotype (e.g. sex)] and [marker name]}

\item{title.cex}{Optionally, character expansion for title.  Defaults to 1.}

\item{genotype.plotting.names}{Labels for the genotype groups.  Defaults to \code{c('AA', 'AB', 'BB')}.}

\item{ribbon.width}{Optionally, width of ribbon connecting same-phenotype (different genotype) groups.
  Defaults to 10.}

\item{xlim}{Optionally specify x-axis limits.  Defaults to data-dependent.}

\item{ylim}{Optionally specify y-axis limits.  Defaults to data.dependent.}
}
\value{
None.  Only makes plot.
}
\description{
\code{predictive.plot} should be used to visually investigate loci identified
   with plot.scanonevar or summary.scanonevar.  The user can specify the same mean and variance
   formulae that were used in the scan, or specify new formulae to investigate interactions.
}
\details{


none
}
\examples{
set.seed(27599)
   my.cross <- sim.cross(map = sim.map(), type = 'f2')
   my.cross <- calc.genoprob(my.cross)
   my.cross$pheno$phenotype <- rnorm(n = 100,
                                     mean = my.cross$geno$`1`$data[,5],
                                     sd = my.cross$geno$`2`$data[,5])
   my.cross$pheno$sex <- rbinom(n = 100, size = 1, prob = 0.5)
   my.cross$pheno$cage <- sample(x = 1:5, size = 100, replace = TRUE)

   predictive.plot(cross = my.cross,
                   mean.formula = 'phenotype ~ sex + mean.QTL.add + mean.QTL.dom',
                   var.formula = '~ sex + var.QTL.add + var.QTL.dom',
                   marker.name = 'D1M5',
                   phen.name = 'sex')

   predictive.plot(cross = my.cross,
                   mean.formula = 'phenotype ~ sex + mean.QTL.add + mean.QTL.dom',
                   var.formula = '~ sex + var.QTL.add + var.QTL.dom',
                   marker.name = 'D2M5',
                   phen.name = 'sex')
}
\author{
Robert Corty \email{rcorty@gmail.com}
}

