% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_var_plots.R, R/phenotype_at_locus_plot.R
\name{mean_var_plot_model_free}
\alias{mean_var_plot_model_free}
\alias{mean_var_plot_model_based}
\alias{phenotype_at_marker_plot}
\title{mean_var_plot_model_free}
\usage{
mean_var_plot_model_free(cross, phenotype.name, grouping.factor.names,
  title = paste(phenotype.name, "by", paste(grouping.factor.names, collapse =
  ", ")))

mean_var_plot_model_based(cross, phenotype.name, focal.groups = NULL,
  nuisance.groups = NULL, genotype.names = c("AA", "AB", "BB"),
  xlim = NULL, ylim = NULL, title = paste(phenotype.name, "by",
  paste(focal.groups, collapse = ", ")), draw_ribbons = TRUE,
  se_line_size = 1, point_size = 1)

phenotype_at_marker_plot(cross, phenotype_name, marker_name, color_by = NULL,
  shape_by = NULL, point_alpha = 1, point_size = 1, Ibars = TRUE,
  connectIbars = TRUE, genotype_labels = NULL)
}
\arguments{
\item{cross}{the cross}

\item{phenotype.name}{the name of the phenotype of interest}

\item{grouping.factor.names}{the factors by which the units are grouped}

\item{title}{plot title}

\item{focal.groups}{the focal covariates, whose effects will be plotted.  Markers or phenotypes.}

\item{nuisance.groups}{the nuisance covariates, whose effects will be modeled, then marginalized over.  Markers or phenotypes.}

\item{genotype.names}{plotting names of genotype groups}

\item{xlim}{x axis limits}

\item{ylim}{y axis limits}

\item{draw_ribbons}{Should ribbons be drawn connecting the sub-groups of the focal groups?}

\item{se_line_size}{thickness of the lines indicating standard error}

\item{point_size}{size of the plotted points}

\item{phenotype_name}{The phenotype to plot}

\item{marker_name}{The marker to stratify observations by}

\item{color_by}{variable name to color the points by}

\item{shape_by}{a discrete phenotype to map to the shape aesthetic of the points}

\item{point_alpha}{alpha value (see-throughness) of the plotted points}

\item{Ibars}{Should I bars be plotted showing the standard deviation of each group?}

\item{connectIbars}{Should the Ibars be connected horizontally?}

\item{genotype_labels}{plotting labels for genotype groups}
}
\value{
Nothing, just plot.

nothing, just the plot.

nothing.  Just plots.
}
\description{
plots with mean along the x axis and standard deviation along the y axis

plotting functions for package vqtl
}
