% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanonevar.boot.R
\name{scanonevar.boot}
\alias{scanonevar.boot}
\title{scanonevar.boot}
\usage{
scanonevar.boot(sov, n.resamples, chr, qtl_type = c("mQTL", "vQTL", "mvQTL"),
  random.seed = 27599, n.cores = parallel::detectCores() - 2,
  silent = FALSE)
}
\arguments{
\item{sov}{the scanonevar whose significance should be assessed empirically in an FWER-controlling method}

\item{n.resamples}{the number of resamples}

\item{chr}{which chromosome to focus on}

\item{qtl_type}{which type of QTL did you detect and want a CI for?  mQTL, vQTL, or mvQTL.}

\item{random.seed}{value to start the random number generator at, for reproducibility}

\item{n.cores}{number of cores to use for the permutations}

\item{silent}{Should all messaging be suppressed?}
}
\value{
27599
}
\description{
\code{scanonevar.boot} conducts a nonparametric bootstrap of one chromosome
to establish a confidence interval on any peaks
}
\examples{
set.seed(27599)
test.cross <- qtl::sim.cross(map = qtl::sim.map(len = rep(20, 5), n.mar = 5), n.ind = 50)
sov <- scanonevar(cross = test.cross)

}
\author{
Robert W. Corty \email{rcorty@gmail.com}
}
