% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rquery_treatment.R
\name{rquery_prepare}
\alias{rquery_prepare}
\alias{materialize_treated}
\title{Materialize a treated data frame remotely.}
\usage{
rquery_prepare(db, rqplan, data_source, result_table_name, ...,
  extracols = NULL, temporary = FALSE, overwrite = TRUE,
  print_rquery = FALSE, print_sql = FALSE)

materialize_treated(db, rqplan, data_source, result_table_name, ...,
  extracols = NULL, temporary = FALSE, overwrite = TRUE,
  print_rquery = FALSE, print_sql = FALSE)
}
\arguments{
\item{db}{a db handle.}

\item{rqplan}{an query plan produced by as_rquery_plan().}

\item{data_source}{relop, data source (usually a relop_table_source).}

\item{result_table_name}{character, table name to land result in}

\item{...}{force later arguments to bind by name.}

\item{extracols}{extra columns to copy.}

\item{temporary}{logical, if TRUE try to make result temporary.}

\item{overwrite}{logical, if TRUE try to overwrite result.}

\item{print_rquery}{logical, if TRUE print the rquery ops.}

\item{print_sql}{logical, if TRUE print the SQL.}
}
\value{
description of treated table.
}
\description{
Materialize a treated data frame remotely.
}
\section{Functions}{
\itemize{
\item \code{materialize_treated}: old name for rquery_prepare function
}}

\seealso{
\code{\link{as_rquery_plan}}, \code{\link{rqdatatable_prepare}}
}
