% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inequalityMeasureBoot.R
\name{ineq.weighted}
\alias{ineq.weighted}
\title{Weighted inequality measures}
\usage{
ineq.weighted(
  X,
  W = rep(1, length(X)),
  Atkinson.e = 1,
  Jenkins.alfa = 0.8,
  Entropy.e = 0.5,
  Kolm.p = 1,
  Kolm.scale = "Standardization",
  Leti.norm = T
)
}
\arguments{
\item{X}{is a data vector}

\item{W}{is a vector of weights}

\item{Atkinson.e}{is a parameter for Atkinson coefficient}

\item{Jenkins.alfa}{is a parameter for Jenkins coefficient}

\item{Entropy.e}{is a generalized entropy index parameter}

\item{Kolm.p}{is a parameter for Kolm index}

\item{Kolm.scale}{method of data standardization before computing}

\item{Leti.norm}{(logical). If TRUE (default) then Leti index is divided by a maximum possible value}
}
\value{
The data frame with weighted mean and sum of X, and all inequality measures.
}
\description{
Calculates weighted mean and sum of X, and a set of inequality measures.
}
\details{
At this moment ineq.weighted calculates all inequality measures available in wINEQ packages.
In future, selection of inequality measures will be available
}
\examples{
library(dplyr)
# Compare weighted and unweighted result.
X=1:10
W=1:10
ineq.weighted(X)
ineq.weighted(X,W)


data(Tourism)
# Results for Total expenditure with sample weights:
X=Tourism$`Total expenditure`
W=Tourism$`Sample weight`
ineq.weighted(X)
ineq.weighted(X,W)

}
