% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-waffle.R, R/stat-waffle.R
\docType{data}
\name{geom_waffle}
\alias{geom_waffle}
\alias{GeomWaffle}
\alias{stat_waffle}
\alias{StatWaffle}
\title{Waffle (Square pie chart) Geom}
\format{
An object of class \code{GeomWaffle} (inherits from \code{GeomRtile}, \code{GeomRrect}, \code{Geom}, \code{ggproto}, \code{gg}) of length 5.

An object of class \code{StatWaffle} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 8.
}
\usage{
geom_waffle(
  mapping = NULL,
  data = NULL,
  n_rows = 10,
  make_proportional = FALSE,
  flip = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  radius = grid::unit(0, "npc"),
  inherit.aes = TRUE,
  ...
)

GeomWaffle

stat_waffle(
  mapping = NULL,
  data = NULL,
  geom = "waffle",
  n_rows = 10,
  make_proportional = FALSE,
  flip = FALSE,
  radius = grid::unit(0, "npc"),
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

StatWaffle
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{aes()} or
\code{aes_()}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{ggplot()}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{fortify()} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame.}, and
will be used as the layer data.}

\item{n_rows}{how many rows should there be in the waffle chart? default is 10}

\item{make_proportional}{compute proportions from the raw values? (i.e. each
value \code{n} will be replaced with \code{n}/\code{sum(n)}); default is \code{FALSE}.}

\item{flip}{If \code{TRUE}, flip x and y coords. n_rows then becomes n_cols.
Useful to achieve waffle column chart effect. Defaults is \code{FALSE}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{radius}{radius for round squares}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{borders()}.}

\item{...}{other arguments passed on to \code{layer()}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{geom}{geom to use (default is "waffle")}
}
\description{
There are two special/critical \code{aes()} mappings:
\itemize{
\item \code{fill} (so the geom knows which column to map the fills to)
\item \code{values} (which column you're mapping the filling for the squares with)
}
}
\examples{
data.frame(
  parts = factor(rep(month.abb[1:3], 3), levels=month.abb[1:3]),
  vals = c(10, 20, 30, 6, 14, 40, 30, 20, 10),
  fct = c(rep("Thing 1", 3), rep("Thing 2", 3), rep("Thing 3", 3))
) -> xdf

ggplot(xdf, aes(fill = parts, values = vals)) +
  geom_waffle() +
  facet_wrap(~fct)
}
\keyword{datasets}
