% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_dummy.R
\name{r_dummy}
\alias{r_dummy}
\title{Generate Random Dummy Values}
\usage{
r_dummy(fun, n, ..., prefix = FALSE, rep.sep = "_")
}
\arguments{
\item{fun}{A \pkg{wakefield} variable function.}

\item{n}{The number of rows to produce.}

\item{prefix}{logical.  If \code{TRUE} the original factor name (supplied to
\code{fun} as \code{name} argument) will prefix the column names that were
generated from the factor's categories.}

\item{rep.sep}{A separator to use for the variable and category part of names
when \code{prefix = TRUE}.  For example if the \code{\link[wakefield]{age}}
is used (\code{r_dummy(sex)}), this results in column names
\code{c("Sex_Male", "Sex_Female")}.}

\item{\ldots}{Additional arguments passed to \code{fun}.}
}
\value{
Returns a \code{\link[dplyr]{tbl_df}}.
}
\description{
Generate random values from a \pkg{wakefield} variable function.
}
\examples{
r_dummy(sex, 10)
r_dummy(race, 1000)
r_dummy(race, 1000, name = "Ethnicity")
}
\seealso{
\code{\link[wakefield]{r_list}},
\code{\link[wakefield]{r_data_frame}},
\code{\link[wakefield]{r_series}}
}
\keyword{dummy}
