% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_wave.R
\name{read_wave}
\alias{read_wave}
\title{A wrapper for tuneR's readWave that read sound files listed within selection tables}
\usage{
read_wave(X, index, from = X$start[index], to = X$end[index], header = FALSE, path = NULL)
}
\arguments{
\item{X}{'data.frame', 'selection_table' or 'extended_selection_table' containing columns for sound file name (sound.files), 
selection number (selec), and start and end time of signals (start and end). 
Low and high frequency columns are optional. Default is \code{NULL}.}

\item{index}{Index of the selection in 'X' that will be read. Ignored if 'X' is \code{NULL}.}

\item{from}{Where to start reading, in seconds. Default is \code{X$start[index]}.}

\item{to}{Where to stop reading, in seconds. Default is \code{X$end[index]}.}

\item{header}{If \code{TRUE}, only the header information of the Wave object is returned, otherwise (the default) the whole Wave object.}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}
}
\value{
An object of class "Wave".
}
\description{
\code{read_wave} A wrapper for tuneR's \code{\link[tuneR]{readWave}} function that read sound files listed within selection tables
}
\details{
The function is a wrapper for \code{\link[tuneR]{readWave}} that read sound files listed within selection tables
ignores file extension mismatches, a common mistake when reading wave files. It 
is also used internally by warbleR functions to read wave objects from extended selection tables (see \code{\link{selection_table}} for details).
}
\examples{
{
# First set temporary folder
# setwd(tempdir())

# write wave files with lower case file extension
data(list = c("Phae.long1"))
writeWave(Phae.long1,"Phae.long1.wav")

read_wave(X = selec.table, index  =  1)
}
}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu})
}
