% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autodetec.R
\name{autodetec}
\alias{autodetec}
\title{Automatically detect vocalizations in sound files}
\usage{
autodetec(X = NULL, threshold = 15, envt = "abs", ssmooth = NULL, msmooth = NULL, 
  power = 1, bp = NULL, osci = FALSE, wl = 512, xl = 1, picsize = 1, res = 100, 
  flim = c(0,22), ls = FALSE, sxrow = 10, rows = 10, mindur = NULL, maxdur = 
  NULL, redo = FALSE, img = TRUE, it = "jpeg", set = FALSE, flist = NULL, smadj = NULL,
  parallel = 1, path = NULL, pb = TRUE, pal = reverse.gray.colors.2, 
  fast.spec = FALSE, ...)
}
\arguments{
\item{X}{'selection_table' object or a data frame with columns
for sound file name (sound.files), selection number (selec), and start and end time of signal
(start and end). The ouptut of \code{\link{manual_loc}} can 
also be used as the input data frame.}

\item{threshold}{A numeric vector of length 1 specifying the amplitude threshold for detecting 
signals (in \%).}

\item{envt}{Character vector of length 1 specifying the type of envelope to
be used: "abs" for absolute amplitude envelope or "hil" for Hilbert 
amplitude envelope. Default is "abs".}

\item{ssmooth}{A numeric vector of length 1 to smooth the amplitude envelope 
with a sum smooth function. Default is NULL.}

\item{msmooth}{A numeric vector of length 2 to smooth the amplitude envelope 
with a mean sliding window. The first component is the window length and 
the second is the overlap between successive windows (in \%). Faster than ssmooth but time detection is 
much less accurate. Will be deprecated in future versions. Default is NULL.}

\item{power}{A numeric vector of length 1 indicating a power factor applied 
to the amplitude envelope. Increasing power will reduce low amplitude 
modulations and increase high amplide modulations, in order to reduce 
background noise. Default is 1 (no change).}

\item{bp}{Numeric vector of length 2 giving the lower and upper limits of a
frequency bandpass filter (in kHz). Default is c(0, 22).}

\item{osci}{Logical argument to add an oscillogram underneath spectrogram, as
in \code{\link[seewave]{spectro}}. Default is \code{FALSE}. Not applied if ls is 
\code{TRUE}.}

\item{wl}{A numeric vector of length 1 specifying the window length of the spectrogram, default 
is 512.}

\item{xl}{Numeric vector of length 1, a constant by which to scale 
spectrogram width. Default is 1.}

\item{picsize}{Numeric argument of length 1. Controls the relative size of 
the spectrogram. Default is 1.}

\item{res}{Numeric argument of length 1 controling resolution of images.
Default is 100 (faster) although 300 - 400 is recommended for publication/ 
presentation quality.}

\item{flim}{A numeric vector of length 2 for the frequency limit in kHz of 
the spectrogram, as in \code{\link[seewave]{spectro}}. Default is c(0, 22).}

\item{ls}{Logical argument. If \code{TRUE}, long spectrograms as in \code{\link{lspec}} 
are produced.}

\item{sxrow}{A numeric vector of length 1. Specifies seconds of spectrogram
per row when creating long spectrograms. Default is 10. Applied when ls =
\code{TRUE} and/or when X is not provided.}

\item{rows}{A numeric vector of length 1. Specifies number of rows per 
image file when creating long spectrograms. Default is 10. Applied when ls =  
\code{TRUE} and/or when X is not provided.}

\item{mindur}{Numeric vector of length 1 giving the shortest duration (in 
seconds) of the signals to be detected. It removes signals below that 
threshold.}

\item{maxdur}{Numeric vector of length 1 giving the longest duration (in 
seconds) of the signals to be detected. It removes signals above that 
threshold.}

\item{redo}{Logical argument. If \code{TRUE} all selections will be analyzed again 
when code is rerun. If \code{FALSE} only the selections that do not have an 'autodetec' generated image 
file in the working directory will be analyzed. Default is \code{FALSE}.}

\item{img}{Logical argument. If \code{FALSE}, image files are not produced. Default is \code{TRUE}.}

\item{it}{A character vector of length 1  giving the image type to be used. Currently only
"tiff" and "jpeg" are admitted. Default is "jpeg".}

\item{set}{A logical argument indicating wheter the settings of the autodetection 
process should be included in the image file name. If \code{TRUE}, threshold (th), envelope (envt), bandpass (bp),
power (pw), smooth (smo, either mmsooth[1] or ssmooth), maxdur (mxdu), and mindur (midu) are included.}

\item{flist}{character vector or factor indicating the subset of files that will be analyzed. Ignored
if X is provided.}

\item{smadj}{adjustment for amplitude smoothing. Character vector of length one indicating whether start end 
values should be adjusted. "start", "end" or "both" are the inputs admitted by this argument. Amplitude 
smoothing through ssmooth generates a predictable deviation from the actual start and end positions of the signals,
determined by the threshold and ssmooth values. This deviation is more obvious (and problematic) when the 
increase and decrease in amplitude at the start and end of the signal (respectively) is not gradual. Ignored if ssmooth is \code{NULL}.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}

\item{pal}{Color palette function for spectrogram. Default is reverse.gray.colors.2. See 
\code{\link[seewave]{spectro}} for more palettes. Palettes as \code{\link[monitoR]{gray.2}} may work better when \code{fast.spec = TRUE}.}

\item{fast.spec}{Logical. If \code{TRUE} then image function is used internally to create spectrograms, which substantially 
increases performance (much faster), although some options become unavailable, as collevels, and sc (amplitude scale).
This option is indicated for signals with high background noise levels. Palette colors \code{\link[monitoR]{gray.1}}, \code{\link[monitoR]{gray.2}}, 
\code{\link[monitoR]{gray.3}}, \code{\link[monitoR]{topo.1}} and \code{\link[monitoR]{rainbow.1}} (which should be imported from the package monitoR) seem
to work better with 'fast.spec' spectograms. Palette colors \code{\link[monitoR]{gray.1}}, \code{\link[monitoR]{gray.2}}, 
\code{\link[monitoR]{gray.3}} offer 
decreasing darkness levels.}

\item{...}{Additional arguments to be passed to a modified version of \code{\link[seewave]{spectro}} for customizing
graphical output.}
}
\value{
Image files with spectrograms showing the start and end of the detected signals. It 
  also returns a data frame containing the start and end of each signal by 
  sound file and selection number.
}
\description{
\code{autodetec} automatically detects the start and end of vocalizations in sound files  based
on amplitude, duration, and frequency range attributes.
}
\details{
This function determines the start and end of signals in the segments of the sound files listed 
  in the input data frame. Alternatively, if no data frame is provided, the function detects signals across
  each entire sound file and creates long spectrograms highlighting the start and of the detected
  signals for all sound files in the working directory. The input data frame should have the following 
  columns: c("sound.files","selec","start","end"). The ouptut of \code{\link{manualoc}} can be used as the 
  input data frame. This function uses a modified version of the \code{\link[seewave]{timer}} function from 
  seewave package to detect signals.
}
\examples{
\dontrun{
# Set temporary working directory
# setwd(tempdir())

data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4"))
writeWave(Phae.long1,"Phae.long1.wav")
writeWave(Phae.long2,"Phae.long2.wav")
writeWave(Phae.long3,"Phae.long3.wav")
writeWave(Phae.long4,"Phae.long4.wav") 

ad <- autodetec(threshold = 5, env = "hil", ssmooth = 300, power=1,
bp=c(2,9), xl = 2, picsize = 2, res = 200, flim= c(1,11), osci = TRUE,
wl = 300, ls = FALSE, sxrow = 2, rows = 4, mindur = 0.1, maxdur = 1, set = TRUE)

#run it with different settings
ad <- autodetec(threshold = 90, env = "abs", ssmooth = 300, power = 1, redo = TRUE,
bp=c(2,9), xl = 2, picsize = 2, res = 200, flim= c(1,11), osci = TRUE, 
wl = 300, ls = FALSE,  sxrow = 2, rows = 4, mindur=0.1, maxdur=1, set = TRUE)

#check this folder!!
getwd()
}

}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu}). Implements a
modified version of the timer function from seewave.
}
