% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xcorr.graph.R
\name{xcorr.graph}
\alias{xcorr.graph}
\title{Pairwise plots of spectrogram cross-correlation scores}
\usage{
xcorr.graph(X, cex.cor = 1, cex.lab = 1, cex.axis.lab = 1, rel.cex = FALSE, labs = NULL)
}
\arguments{
\item{X}{Output from \code{\link{xcorr}} function.}

\item{cex.cor}{A numeric vector of length 1 giving the amount by which correlation scores (in 
the upper triangle of the multipannel plot) should be magnified. Default is 1.}

\item{cex.lab}{A numeric vector of length 1 giving the amount by which signal selection labels 
(in diagonal of the multipannel plot) should be magnified. Default is 1.}

\item{cex.axis.lab}{A numeric vector of length 1 giving the amount by which the axis labels should be magnified. Default is 1.}

\item{rel.cex}{Logical. Controls whether the size of the correlation scores (in 
the upper triangle of the multipannel plot) should be relative to the correlation score.}

\item{labs}{Alternative selection labels. If not provided the combined name of sound files and selection numbers are used as labels.
Default is \code{FALSE}.}
}
\description{
\code{xcorr.graph} Generates pairwise plots showing the spectrogram cross-correlation scores
against the time sliding.
}
\details{
This function generates pairwise plots of the spectrogram cross-correlation scores
by sliding step. The function takes the output of \code{\link{xcorr}} as input.  The colors of 
the lines in the lower triangle of the plot matrix represent the strenght of the similarity between
the two signals. The x axis shows the time difference between the two signals for each sliding step
(0 means perfectly centered signals). Note that large number of signals may not display well in the 
default graphic device. In such cases saving the plot as and image file is adviced.
}
\examples{
\dontrun{
#load data
#First set temporal working directory]
setwd(tempdir())

#load data
data(list = c("Phae.long1", "Phae.long2", "manualoc.df"))
writeWave(Phae.long1, "Phae.long1.wav") #save sound files
writeWave(Phae.long2, "Phae.long2.wav")

 #run cross correlation first
 xcor<-xcorr(X = manualoc.df[1:5,], wl =300, frange= c(2, 9), ovlp=90, dens=0.8, wn='hanning', 
 cor.method = "pearson") 
 
 #plot pairwise scores
  xcorr.graph(X = xcor, cex.cor = 2, cex.lab = 1, rel.cex = FALSE)
}
}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu})
}
\seealso{
\code{\link{xcorr}}
}

