% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selection_table.R
\name{is_selection_table}
\alias{is_selection_table}
\title{Class 'selection_table': double-checked frequency/time coordinates of selections}
\usage{
is_selection_table(x)
}
\arguments{
\item{x}{R object.}
}
\value{
A logical argument indicating whether the object class is 'selection_table'
}
\description{
Class for selections of signals in sound files
}
\details{
An object of class \code{selection_table} created by \code{\link{selection_table}} is a list with the following elements:
 \itemize{
 \item\code{selections}: data frame containing the frequency/time coordinates of the selections, sound file names, and any  additional information
 \item \code{check.resutls}: results of the checks on data consistency using \link{checksels}
}
}
\examples{
{
# load data
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "lbh_selec_table"))

is_selection_table(lbh_selec_table)

# save wave files in temporary directory
writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav"))
writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))
writeWave(Phae.long3, file.path(tempdir(), "Phae.long3.wav"))
writeWave(Phae.long4, file.path(tempdir(), "Phae.long4.wav"))

st <- selection_table(lbh_selec_table, path = tempdir())

is_selection_table(st)

class(st)
}
}
\seealso{
\code{\link{selection_table}}
Check if object is of class "selection_table"

\code{is_selection_table} Check if the object belongs to the class "selection_table"

\code{\link{selection_table}}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
