% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_peaks.R
\name{find_peaks}
\alias{find_peaks}
\title{Find cross-correlation peaks}
\usage{
find_peaks(xc.output, parallel = 1, cutoff = 0.4, path = NULL, pb = TRUE, 
max.peak = FALSE, output = "data.frame")
}
\arguments{
\item{xc.output}{output of \code{\link{cross_correlation}} after setting \code{output = "list"}.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{cutoff}{Numeric vector of length 1 with a value between 0 and 1 specifying the correlation cutoff for detecting peaks. Default is 0.4.}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}

\item{max.peak}{Logical argument to control whether only the peak with the highest correlation value is returned (if TRUE; cutoff will be ignored). Default is \code{FALSE}.}

\item{output}{Character vector of length 1 to determine if only the detected peaks are returned ('cormat') or a list ('list') containing 1) the peaks  and 2) a data frame with correlation values at each sliding step for each comparison. The list, which is also of class 'peaks.output', can be used to graphically explore detections using \code{\link{full_spectrograms}}.}
}
\value{
The function returns a data frame with time and correlation score for the  
detected peaks.
}
\description{
\code{find_peaks} find peaks in cross-correlation scores from \code{\link{cross_correlation}}
}
\details{
This function finds cross-correlation peaks along signals (analogous to \code{\link[monitoR]{findPeaks}}).
}
\examples{
{
# load data
data(list = c("Phae.long4", "Phae.long2", "lbh_selec_table2", "comp_matrix"))

# save sound files
writeWave(Phae.long4, file.path(tempdir(), "Phae.long4.wav")) 
writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))

# run cross-correlation
xc.output <- cross_correlation(X = lbh_selec_table2, output = "list", 
compare.matrix = comp_matrix, path = tempdir())

# find peaks
pks <- find_peaks(xc.output = xc.output, path = tempdir())
}
}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.

H. Khanna, S.L.L. Gaunt & D.A. McCallum (1997). Digital spectrographic cross-correlation: tests of sensitivity. Bioacoustics 7(3): 209-234
}
}
\seealso{
\code{\link{auto_detec}}, \code{\link[monitoR]{findPeaks}}
}
\author{
Marcelo Araya-Salas \email{marcelo.araya@ucr.ac.cr})
}
