% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duration_sound_files.R
\name{duration_sound_files}
\alias{duration_sound_files}
\title{Measure the duration of sound files}
\usage{
duration_sound_files(files = NULL, path = NULL, skip.error = FALSE,
file.format = "\\\.wav$|\\\.wac$|\\\.mp3$|\\\.flac$")
}
\arguments{
\item{files}{Character vector with the names of the sound files to be measured. The sound files should be in the working directory or in the directory provided in 'path'.}

\item{path}{Character string containing the directory path where the sound files are located.}

\item{skip.error}{Logical to control if errors are omitted. If so, files that could not be read will return \code{NA} in the 'duration' column. Default is \code{FALSE}, which will return an error if some files are problematic.
If \code{NULL} (default) then the current working directory is used.}

\item{file.format}{Character string with the format of sound files. By default all sound file formats supported by warbleR are included ("\\.wav$|\\.wac$|\\.mp3$|\\.flac$"). Note that several formats can be included using regular expression syntax as in \code{\link[base]{grep}}. For instance \code{"\\.wav$|\\.mp3$"} will only include .wav and .mp3 files.}
}
\value{
A data frame with the duration (in seconds) of the sound files.
}
\description{
\code{duration_sound_files} measures the duration of sound files
}
\details{
This function returns the duration (in seconds) of sound files.
}
\examples{
{
  data(list = c("Phae.long1", "Phae.long2", "Phae.long3"))
  writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav"))
  writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))
  writeWave(Phae.long3, file.path(tempdir(), "Phae.long3.wav"))

  duration_sound_files(path = tempdir())
}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
