% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_sels.R
\name{check_sels}
\alias{check_sels}
\title{Check selection data frames}
\usage{
check_sels(
  X = NULL,
  parallel = 1,
  path = NULL,
  check.header = FALSE,
  pb = TRUE,
  wav.size = FALSE,
  verbose = TRUE,
  fix.selec = FALSE
)
}
\arguments{
\item{X}{'selection_table' object or data frame with the following columns: 1) "sound.files": name of the .wav
files, 2) "sel": number of the selections, 3) "start": start time of selections, 4) "end":
end time of selections. Alternatively, a 'selection_table' class object can be input to double check selections.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{path}{Character string containing the directory path where the sound files are located.
If \code{NULL} (default) then the current working directory is used.}

\item{check.header}{Logical. Controls whether sound file headers correspond to the actual file properties
(i.e. if is corrupted). This could significantly affect the performance of the function (much slower) particularly
with long sound files.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}

\item{wav.size}{Logical argument to control if the size of the wave object
when the selection is imported into R (as when using \code{\link[tuneR]{readWave}}
is calculated and added as a column. Size is return in MB. Default is \code{FALSE}.}

\item{verbose}{Logical to control whether the summary messages are printed to the console. Defaut is \code{TRUE}.}

\item{fix.selec}{Logical to control if labels in 'selec' column should be fixed. This column should not be duplicated within a sound file. If that happens and \code{fix.selec = TRUE} duplicated labels will be changed. Default is \code{FALSE}.}
}
\value{
A data frame including the columns in the input data frame (X) and the following additional columns:
\itemize{
   \item \code{check.res}: diagnose for each selection
   \item \code{duration}: duration of selection in seconds
   \item \code{min.n.samples} number of samples in a selection. Note the number of samples available
in a selection limits the minimum window length (wl argument in other functions) that can be used in batch analyses.
   \item \code{sample.rate}: sampling rate in kHz
   \item \code{channels}: number of channels
   \item \code{bits}: bit depth
   \item \code{sound.file.samples}: number of samples in the sound file
   }
}
\description{
\code{check_sels} checks whether selections can be read by subsequent functions.
}
\details{
This function checks the information in a selection data frame or selection table (i.e. data frame with annotations on sound files)
to avoid problems in any warbleR analysis downstream. It specifically checks if:
\itemize{
   \item 'X' is an object of class 'data.frame' or 'selection_table' (see \code{\link{selection_table}}) and contains
   the required columns to be used on any warbleR function ('sound.files', 'selec', 'start', 'end', if not returns an error)
   \item  'sound.files' in 'X' correspond to sound files in the working directory or in the provided 'path'
    (if no file is found returns an error, if some files are not found returns error info in the ouput data frame)
   \item time ('start', 'end') and frequency ('bottom.freq', 'top.freq', if provided) limit parameters are numeric and
   don't contain NAs (if not returns an error)
   \item there are no duplicated selection labels ('selec') within a sound file (if not returns an error)
   \item sound files can be read (error info in the ouput data frame)
   \item the start and end time of the selections are found within the duration of the sound files (error info in the ouput data frame)
   \item sound files can be read (error info in the ouput data frame)
   \item sound files header is not corrupted (only if \code{header = TRUE}, error info in the ouput data frame)
   \item selection time position (start and end) doesn't exceeds sound file length (error info in the ouput data frame)
   \item 'top.freq' is lower than half the sample rate (nyquist frequency, error info in the ouput data frame)
   \item negative values aren't found in time or frequency limit parameters (error info in the ouput data frame)
   \item 'start' higher than 'end' or 'bottom.freq' higher than 'top.freq' (error info in the ouput data frame)
   \item 'channel' value is not higher than number of channels in sound files (error info in the ouput data frame)
}
The function returns a data frame that includes the information in 'X' plus additional columns about the format of sound
files (see 'Value') as well as the result of the checks ('check.res' column, value is 'OK' if everything is fine).
Sound files should be in the working directory (or the directory provided in 'path'). Corrupt files can be fixed using
\code{\link{fix_wavs}}.
}
\examples{
{
# save wav file examples
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "lbh_selec_table"))
writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav"))
writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))
writeWave(Phae.long3, file.path(tempdir(), "Phae.long3.wav"))

check_sels(X = lbh_selec_table, path = tempdir())
}
}
\references{
{Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.}
}
\seealso{
\code{\link{check_sound_files}}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
