% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wasp.R
\name{wasp}
\alias{wasp}
\title{Compute Wasserstein barycenters of subset posteriors}
\source{
Puccetti, G., Rüschendorf, L. & Vanduffel, S. (2020). On the
  computation of Wasserstein barycenters, Journal of Multivariate Analysis,
  176.
}
\usage{
wasp(mcmc, par.names = NULL, acc = 0.001, iter = 10, out = FALSE)
}
\arguments{
\item{mcmc}{a three dimensional array (rows =  number of subset posteriors,
columns = number of parameters of the posterior distribution, slices =
samples number of samples for each subset posterior) containing posterior
samples for all subsets}

\item{par.names}{optional character vector with parameter names}

\item{acc}{accuracy of the swapping algorithm (default = 0.001)}

\item{iter}{maximum number of iterations of the swapping algorithm (default = 10)}

\item{out}{boolean indicating whether output for each iteration of the swapping algorithm should be displayed (default = false)}
}
\value{
A \code{wasp} object, which can be further analyzed using the
  associated function \code{\link{summary.wasp}}.

  A \code{wasp} object contains the following elements (some elements are not
  returned if not applicable)

  \describe{
  \item{\code{barycenter}}{A matrix of posterior samples (rows) for
  all parameters (columns) of the full posterior obtained by the swapping algorithm.}
  \item{\code{raw}}{An array (\code{dim = c(subsets, parameters, samples)})
  containing the raw output from the swapping algorithm.}
  \item{\code{call}}{The call to the \code{wasp()} function.}
  \item{\code{subsets}}{The amount of subset posteriors in mcmc.}
  \item{\code{parameters}}{The amount of parameters in mcmc.}
  \item{\code{samples}}{The amount of posterior samples for each subset posterior in mcmc.}
  \item{\code{acc}}{Accuracy of the swapping algorithm, default = 0.001.}
  \item{\code{iter}}{Maximum amount of iterations for the swapping algorithm, default = 10.}
  }
}
\description{
This function computes Wasserstein Barycenters of subset posteriors and
gives posterior summaries for the full posterior.
}
\details{
The swapping algorithm developed by Puccetti, Rüschendorf and
  Vanduffel (2020) is used to compute Wasserstein barycenters of subset
  posteriors.
}
\examples{

library(waspr)
out <- wasp(pois_logistic,
            par.names = c("beta_s", "alpha_l", "beta_l",
                          "baseline_sigma", "baseline_mu",
                          "correlation", "sigma_s", "sigma_l"))
summary(out)

}
