% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{ww_build_neighbors}
\alias{ww_build_neighbors}
\title{Make 'nb' objects from sf objects}
\usage{
ww_build_neighbors(data, nb = NULL, ..., call = rlang::caller_env())
}
\arguments{
\item{data}{An sf object (of class "sf" or "sfc").}

\item{nb}{An object of class "nb" (in which case it will be returned
unchanged), or a function to create an object of class "nb" from \code{data} and
\code{...}, or \code{NULL}. See details.}

\item{...}{Arguments passed to the neighbor-creating function.}

\item{call}{The execution environment of a currently running
function, e.g. \code{call = caller_env()}. The corresponding function
call is retrieved and mentioned in error messages as the source
of the error.

You only need to supply \code{call} when throwing a condition from a
helper function which wouldn't be relevant to mention in the
message.

Can also be \code{NULL} or a \link[rlang:topic-defuse]{defused function call} to
respectively not display any call or hard-code a code to display.

For more information about error calls, see \ifelse{html}{\link[rlang:topic-error-call]{Including function calls in error messages}}{\link[rlang:topic-error-call]{Including function calls in error messages}}.}
}
\value{
An object of class "nb".
}
\description{
Make 'nb' objects from sf objects
}
\details{
When \code{nb = NULL}, the method used to create neighbors from \code{data} is
dependent on what geometry type \code{data} is:
\itemize{
\item If \code{nb = NULL} and \code{data} is a point geometry
(classes "sfc_POINT" or "sfc_MULTIPOINT") the "nb" object will be created
using \code{\link[=ww_make_point_neighbors]{ww_make_point_neighbors()}}.
\item If \code{nb = NULL} and \code{data} is a polygon geometry
(classes "sfc_POLYGON" or "sfc_MULTIPOLYGON") the "nb" object will be created
using \code{\link[=ww_make_polygon_neighbors]{ww_make_polygon_neighbors()}}.
\item If \code{nb = NULL} and \code{data} is any other geometry type, the "nb" object will
be created using the centroids of the data as points, with a warning.
}
}
