% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ids_get.R
\name{ids_get}
\alias{ids_get}
\title{Fetch Debt Statistics from the World Bank International Debt Statistics API}
\usage{
ids_get(
  geographies,
  series,
  counterparts = "all",
  start_date = NULL,
  end_date = NULL,
  progress = FALSE
)
}
\arguments{
\item{geographies}{A character vector representing the geographic codes
(e.g., "ZMB" for Zambia). This argument is required and cannot contain NA
values.}

\item{series}{A character vector representing the series codes (e.g.,
"DT.DOD.DPPG.CD"). This argument is required and cannot contain NA values.}

\item{counterparts}{A character vector representing counterpart areas (e.g.,
"all", "001"). This argument is required and cannot contain NA values
(default: "all").}

\item{start_date}{An optional numeric value representing the starting year
(e.g., 2015). It must be greater than or equal to 1970. If not provided, the
entire time range is used.}

\item{end_date}{An optional numeric value representing the ending year (e.g.,
2020). It must be greater than or equal to 1970 and cannot be earlier than
\code{start_date}. If not provided, the entire available time range is used.}

\item{progress}{A logical value indicating whether to display a progress
message during the request process (default: \code{FALSE}). Must be either \code{TRUE}
or \code{FALSE}.}
}
\value{
A tibble containing debt statistics with the following columns:
\describe{
\item{geography_id}{The unique identifier for the geography (e.g., "ZMB").}
\item{series_id}{The unique identifier for the series (e.g.,
"DT.DOD.DPPG.CD").}
\item{counterpart_id}{The unique identifier for the counterpart (e.g.,
"all").}
\item{year}{The year corresponding to the data (e.g., 2020).}
\item{value}{The numeric value representing the statistic for the given
geography, series, counterpart, and year.}
}
}
\description{
This function returns a tibble with debt statistics data fetched from the
World Bank International Debt Statistics (IDS) API. The data can be filtered
by geographies, series, counterparts, and time periods.
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Fetch data for a series without specifying a time range or counterpart
ids_get(
  geographies = "ZMB",
  series = "DT.DOD.DPPG.CD",
)

# Fetch specific debt statistics for Zambia from 2015 to 2020
ids_get(
  geographies = "ZMB",
  series = c("DT.DOD.DPPG.CD", "BM.GSR.TOTL.CD"),
  start_date = 2015,
  end_date = 2020
)

# Fetch data for specific counterparts
ids_get(
  geographies = "ZMB",
  series = "DT.DOD.DPPG.CD",
  counterparts = c("216", "231")
)

# Fetch data for multiple geographies and counterparts
ids_get(
  geographies = c("ZMB", "CHN"),
  series = "DT.DOD.DPPG.CD",
  counterparts = c("216", "231"),
  start_date = 2019,
  end_date = 2020
)
}
\dontshow{\}) # examplesIf}
}
