% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stations.R
\name{stations}
\alias{stations}
\title{Access Station data downloaded from Environment and Climate Change Canada}
\format{
A data frame:
\describe{
\item{prov}{Province}
\item{station_name}{Station name}
\item{station_id}{Environment Canada's station ID number. Required for
downloading station data.}
\item{climate_id}{Climate ID number}
\item{WMO_id}{Climate ID number}
\item{TC_id}{Climate ID number}
\item{lat}{Latitude of station location in degree decimal format}
\item{lon}{Longitude of station location in degree decimal format}
\item{elev}{Elevation of station location in metres}
\item{tz}{Local timezone excluding any Daylight Savings}
\item{interval}{Interval of the data measurements ('hour', 'day', 'month')}
\item{start}{Starting year of data record}
\item{end}{Ending year of data record}
\item{normals}{Whether current climate normals are available for that station}
\item{normals_1981_2010}{Whether 1981-2010 climate normals are available for that station}
\item{normals_1971_2000}{Whether 1981-2010 climate normals are available for that station}
}
}
\source{
\url{https://climate.weather.gc.ca/index_e.html}
}
\usage{
stations()
}
\description{
This function access the built-in stations data frame. You can update this
data frame with \code{stations_dl()} which will update the locally stored data.
}
\details{
You can check when this was last updated with \code{stations_meta()}.

A dataset containing station information downloaded from Environment and
Climate Change Canada. Note that a station may have several station IDs,
depending on how the data collection has changed over the years. Station
information can be updated by running \code{stations_dl()}.
}
\examples{
\dontshow{if (check_eccc()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

stations()
stations_meta()

library(dplyr)
filter(stations(), interval == "hour", normals == TRUE, prov == "MB")

\dontshow{\}) # examplesIf}
}
