% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moisture_conversions.R
\name{humidity.to.dewpoint}
\alias{humidity.to.dewpoint}
\title{Calculate dew point temperature.}
\usage{
humidity.to.dewpoint(rh = NA, t = NA, temperature.metric = "fahrenheit")
}
\arguments{
\item{rh}{Numeric vector of relative humidity (in \%).}

\item{t}{Numeric vector of air temperatures.}

\item{temperature.metric}{Character string indicating the temperature
metric of air temperature. Possible values are \code{fahrenheit} or
\code{celsius}.}
}
\value{
A numeric vector of dew point temperature, in the same metric
   as the temperature vector (as specified by the \code{temperature.metric}
   option).
}
\description{
\code{humidity.to.dewpoint} creates a numeric vector of dew point
   temperature from numeric vectors of air temperature and relative
   humidity.
}
\details{
Dew point temperature will be calculated in the same metric as
   the temperature vector (as specified by the \code{temperature.metric}
   option). If you'd like dew point temperature in a different metric,
    use the function \code{\link{celsius.to.fahrenheit}} or
    \code{\link{fahrenheit.to.celsius}} on the output from this function.
}
\note{
Equations are from the source code for the US National Weather
    Service's
    \href{http://www.wpc.ncep.noaa.gov/html/heatindex.shtml}{online heat index calculator}.
}
\examples{
# Calculate dew point temperature from relative humidity and
# air temperature.

data(newhaven)
newhaven$DP <- humidity.to.dewpoint(t = newhaven$TemperatureF,
                                    rh = newhaven$Relative.Humidity,
                                    temperature.metric = 'fahrenheit')
newhaven

}
\author{
Brooke Anderson \email{brooke.anderson@colostate.edu},
Roger Peng \email{rdpeng@gmail.com}
}
\references{
National Weather Service Hydrometeorological Prediction
   Center Web Team. Heat Index Calculator. 30 Jan 2015.
   \url{http://www.wpc.ncep.noaa.gov/html/heatindex.shtml}.
   Accessed 18 Dec 2015.
}
\seealso{
\code{\link{dewpoint.to.humidity},
   \link{fahrenheit.to.celsius},
   \link{celsius.to.fahrenheit}}
}

