% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/allanwood.R
\name{allanwood}
\alias{allanwood}
\title{Query http://www.alanwood.net/pesticides}
\usage{
allanwood(x, type = c("commonname", "cas"), verbose = TRUE)
}
\arguments{
\item{x}{character; search string}

\item{type}{character; type of input}

\item{verbose}{logical; print message during processing to console?}
}
\value{
A list of eight entries: common-name, status, preferredd IUPAC Name,
         IUPAC Name, cas, formula, activity, inchikey, inchi
}
\description{
Query Allan Woods Compendium of Pesticide Common Names http://www.alanwood.net/pesticides
}
\note{
for type = 'cas' only the first link is returned
}
\examples{
\dontrun{
allanwood('Fluazinam', type = 'commonname')
sapply(c('Fluazinam', 'Diclofop', 'xxxxx'), allanwood, type = 'com')
allanwood("79622-59-6", type = 'cas')
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}

