% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikidata.R
\name{get_wdid}
\alias{get_wdid}
\title{Get Wikidata Item ID}
\usage{
get_wdid(
  query,
  match = c("best", "first", "all", "ask", "na"),
  verbose = getOption("verbose"),
  language = "en"
)
}
\arguments{
\item{query}{character; The searchterm}

\item{match}{character; How should multiple hits be handeled? 'all' returns
all matched IDs, 'first' only the first match, 'best' the best matching (by
name) ID, 'ask' is a interactive mode and the user is asked for input, na'
returns NA if multiple hits are found.}

\item{verbose}{logical; print message during processing to console?}

\item{language}{character; the language to search in}
}
\value{
if match = 'all' a list with ids, otherwise a dataframe with 4 columns:
id, matched text, string distance to match and the queried string
}
\description{
Search www.wikidata.org for wikidata item identifiers.  Note that this search
is currently not limited to chemical substances, so be sure to check your
results.
}
\note{
Only matches in labels are returned.
}
\examples{
\dontrun{
get_wdid('Triclosan', language = 'de')
get_wdid('DDT')
get_wdid('DDT', match = 'all')

# multiple inputs
comps <- c('Triclosan', 'Glyphosate')
get_wdid(comps)
}
}
