% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsin.R
\name{opsin_query}
\alias{opsin_query}
\title{OPSIN web interface}
\usage{
opsin_query(query, verbose = getOption("verbose"), ...)
}
\arguments{
\item{query}{character;  chemical name that should be queryed.}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{...}{currently not used.}
}
\value{
a tibble with six columnns: "query", inchi", "stdinchi", "stdinchikey", "smiles", "message", and "status"
}
\description{
Query the OPSIN  (Open Parser for Systematic IUPAC nomenclature) web service
\url{https://opsin.ch.cam.ac.uk/instructions.html}.
}
\examples{
\dontrun{
opsin_query('Cyclopropane')
opsin_query(c('Cyclopropane', 'Octane'))
opsin_query(c('Cyclopropane', 'Octane', 'xxxxx'))
}
}
\references{
Lowe, D. M., Corbett, P. T., Murray-Rust, P., & Glen, R. C. (2011).
Chemical Name to Structure: OPSIN, an Open Source Solution. Journal of Chemical Information and Modeling,
51(3), 739–753. \doi{10.1021/ci100384d}
}
