% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_map.R
\name{make_map}
\alias{make_map}
\title{Create a web map using TNM services}
\usage{
make_map(maps, ..., protocol = c("WMTS", "WMS"), collapse = FALSE)
}
\arguments{
\item{maps}{'character' vector.
TNM base maps to include in the web map. Choices include
\code{"Topo"}, \code{"Imagery Only"}, \code{"Imagery Topo"}, \code{"Hydrography"}, \code{"Shaded Relief"}, and \code{"Blank"}.
See 'Details' section for a description of each base map.
By default, all base maps are included.
The one exception is the \code{"Blank"} map,
which is only accessible using a Web Map Service (WMS),
see \code{protocol} argument.}

\item{...}{Arguments to be passed to the \code{\link[leaflet:leaflet]{leaflet::leaflet}} function.}

\item{protocol}{'character' string.
Standard protocol for serving pre-rendered georeferenced TNM map tiles.
Select \code{"WMTS"} for the Web Map Tile Service (the default) and \code{"WMS"} for the Web Map Service.}

\item{collapse}{'logical' flag.
Whether the layers control should be rendered as an icon that expands when hovered over.
Default is \code{FALSE}.}
}
\value{
An object of class 'leaflet', a hypertext markup language (HTML) map widget.
See example for instructions on how to add additional graphic layers
(such as points, lines, and polygons) to the map widget.
Graphic layers added to the web map must be in latitude and longitude using WGS 84
(also known as \href{https://epsg.io/4326}{EPSG:4326}).
}
\description{
Create a \href{https://leafletjs.com/}{Leaflet} map widget with base maps offered through
The National Map (\href{https://www.usgs.gov/programs/national-geospatial-program/national-map}{TNM}).
Information about the content of these base maps can be found within the
\href{https://apps.nationalmap.gov/help/3.0\%20TNM\%20Base\%20Maps.htm}{TNM Base Maps} document.
The map widget can be rendered on HTML pages generated from R Markdown, Shiny, or other applications.
}
\details{
Map \href{https://apps.nationalmap.gov/services}{service endpoints}
are offered through TNM with no use restrictions.
However, map content is limited to the United States and territories.
This function integrates TNM endpoint services within an interactive web map using
\href{https://rstudio.github.io/leaflet/}{Leaflet for R}.

TNM base maps include:
\itemize{
\item \code{Topo} combines the most current TNM data, and other public-domain data, into a multi-scale
topographic reference map. Data includes boundaries, geographic names, transportation,
contours, hydrography, land cover, shaded relief, and bathymetry.\if{html}{\out{<br/>}}
\figure{basemap-topo.png}
\item \verb{Imagery Only} is the orthoimagery in TNM. Orthoimagery data typically are high resolution aerial images
that combine the visual attributes of an aerial photograph with the spatial accuracy and reliability of a
planimetric map. USGS digital orthoimage resolution may vary from 6 inches to 1 meter.\if{html}{\out{<br/>}}
\figure{basemap-imagery-only.png}
\item \verb{Imagery Topo} is the orthoimagery in TNM as a backdrop, and a limited selection of topographic data
(boundaries, names, transportation, contours, and hydrography).\if{html}{\out{<br/>}}
\figure{basemap-imagery-topo.png}
\item \code{Hydrography} is a cartographic representation of the
\href{https://www.usgs.gov/national-hydrography/national-hydrography-dataset}{National Hydrography Dataset} (NHD).
The NHD is a comprehensive set of digital geospatial data that encodes information about naturally occurring
and constructed bodies of surface water, paths through which water flows, related features such as
stream gages and dams, and additional hydrologic information.\if{html}{\out{<br/>}}
\figure{basemap-hydrography.png}
\item \verb{Shaded Relief} is a terrain representation in the form of hillshades created from the
\href{https://www.usgs.gov/3d-elevation-program}{3D Elevation Program} (3DEP). 3DEP maintains a seamless dataset
of best available raster elevation data, in the form of digital elevation models (DEMs) for the conterminous
United States, Alaska, Hawaii, and Territorial Islands of the United States.\if{html}{\out{<br/>}}
\figure{basemap-shaded-relief.png}
\item \code{Blank} consists of ocean tints to give the outline of land cover as an empty base map.\if{html}{\out{<br/>}}
\figure{basemap-blank.png}
}
}
\examples{
# define arbitrary coordinate locations in decimal degrees
pts <- rbind(
  c(-112.049705, 43.517810),
  c(-122.171257, 37.456526),
  c( -77.367458, 38.947206),
  c(-149.803565, 61.187905),
  c( -80.248344, 26.080860)
)

# create map widget and add markers at coordinate locations
map <- make_map() |>
  leaflet::addMarkers(pts[, 1], pts[, 2])

# print map widget
map

# print map of satellite imagery with a rectangle in the vicinity of UCLA
make_map(c("Imagery Only", "Topo"), collapse = TRUE) |>
  leaflet::addRectangles(
    lng1 = -118.456554,
    lat1 =   34.078039,
    lng2 = -118.436383,
    lat2 =   34.062717,
    fillColor = "transparent"
  )
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
