% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_prob}
\alias{plot_prob}
\title{Probability Plotting Method for Univariate Lifetime Distributions}
\usage{
plot_prob(x, y, event, id = rep("XXXXXX", length(x)),
  distribution = c("weibull", "lognormal", "loglogistic"),
  title_main = "Probability Plot", title_x = "Characteristic",
  title_y = "Unreliability", title_trace = "Sample")
}
\arguments{
\item{x}{a numeric vector which consists of lifetime data. Lifetime
data could be every characteristic influencing the reliability of a product,
e.g. operating time (days/months in service), mileage (km, miles), load
cycles.}

\item{y}{a numeric vector which consists of estimated failure probabilities
regarding the lifetime data in \code{x}.}

\item{event}{a vector of binary data (0 or 1) indicating whether unit \emph{i}
is a right censored observation (= 0) or a failure (= 1).}

\item{id}{a character vector for the identification of every unit.}

\item{distribution}{supposed distribution of the random variable. Can be
\code{"weibull"}, \code{"lognormal"} or \code{"loglogistic"}. Other
distributions have not been implemented yet.}

\item{title_main}{a character string which is assigned to the main title
of the plot.}

\item{title_x}{a character string which is assigned to the title of the
x axis.}

\item{title_y}{a character string which is assigned to the title of the
y axis.}

\item{title_trace}{a character string whis is assigned to the trace shown in
the legend.}
}
\value{
Returns a plotly object containing the layout of the probability plot
  provided by \code{\link{plot_layout}} and the plotting positions.
}
\description{
This function is used to apply the graphical technique of probability
plotting.
}
\details{
The marker label for x is determined by the first word provided in the
argument \code{title_x}, i.e. if \code{title_x = "Mileage in km"} the x label
of the marker is "Mileage".

The marker label for y is determined by the string provided in the
argument \code{title_y}, i.e. if \code{title_y = "Probability in percent"} the y
label of the marker is "Probability".
}
\examples{
obs   <- seq(10000, 100000, 10000)
state <- c(0, 1, 1, 0, 0, 0, 1, 0, 1, 0)
id <- LETTERS[1:length(obs)]

df_john <- johnson_method(x = obs, event = state, id = id)

plot_weibull <- plot_prob(x = df_john$characteristic,
                          y = df_john$prob,
                          event = df_john$status,
                          id = df_john$id,
                          distribution = "weibull",
                          title_main = "Weibull Analysis",
                          title_x = "Mileage in miles",
                          title_y = "Probability of Failure in \%",
                          title_trace = "Failed Items")
}
