# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

getLambda <- function(x, weights, status, beta) {
    .Call(`_weibulltools_getLambda`, x, weights, status, beta)
}

g <- function(x, weights, status, beta) {
    .Call(`_weibulltools_g`, x, weights, status, beta)
}

gDiv <- function(x, weights, beta) {
    .Call(`_weibulltools_gDiv`, x, weights, beta)
}

NewtonRaphson <- function(x, weights, status) {
    .Call(`_weibulltools_NewtonRaphson`, x, weights, status)
}

MStepWeibull <- function(x, posterior, status) {
    .Call(`_weibulltools_MStepWeibull`, x, posterior, status)
}

weibullDensity <- function(x, beta, lambda, censored) {
    .Call(`_weibulltools_weibullDensity`, x, beta, lambda, censored)
}

LikelihoodWeibull <- function(x, parameter, status, prior, P, logL) {
    invisible(.Call(`_weibulltools_LikelihoodWeibull`, x, parameter, status, prior, P, logL))
}

normalize <- function(M) {
    invisible(.Call(`_weibulltools_normalize`, M))
}

#' EM-Algorithm using Newton-Raphson Method
#'
#' This method uses the EM-Algorithm to estimate the parameters of a univariate
#' mixture model. Until now, the mixture model can consist of k two-parametric
#' Weibull distributions. The Weibull distributions are parameterized with scale
#' \eqn{\eta} and shape \eqn{\beta}. In M-step these parameters are estimated using
#' Newton-Raphson. This function is implemented in c++ and is called in function
#' \code{\link{mixmod_em}}.
#'
#' @encoding UTF-8
#' @references Doganaksoy, N.; Hahn, G.; Meeker, W. Q., Reliability Analysis by
#'   Failure Mode, Quality Progress, 35(6), 47-52, 2002
#'
#' @param x a numeric vector which consists of lifetime data. Lifetime
#'  data could be every characteristic influencing the reliability of a product,
#'  e.g. operating time (days/months in service), mileage (km, miles), load
#'  cycles.
#' @param event a vector of binary data (0 or 1) indicating whether unit \emph{i}
#'   is a right censored observation (= 0) or a failure (= 1).
#' @param post a numeric matrix specifiying initial a-posteriori probabilities.
#'   The number of rows have to be in line with observations \code{x} and the
#'   number of columns must equal the mixture components \code{k}.
#' @param distribution supposed distribution of mixture model components.
#'   The value must be \code{"weibull"}. Other distributions have not been
#'   implemented yet.
#' @param k integer of mixture components, default is 2.
#' @param method default method is \code{"EM"}. Other methods have not been
#'   implemented yet.
#' @param n_iter integer defining the maximum number of iterations.
#' @param conv_limit numeric value defining the convergence limit.
#'
#' @return Returns a list with the following components:
#'   \itemize{
#'   \item \code{coefficients} : A matrix with estimated Weibull parameters. In the
#'     first row the estimated scale parameters \eqn{\eta} and in the second the
#'     estimated shape parameters \eqn{\beta} are provided. The first column belongs
#'     to the first mixture component and so forth.
#'   \item \code{posteriori} : A matrix with estimated a-posteriori probabilities.
#'   \item \code{priori} : A vector with estimated a-priori probabilities.
#'   \item \code{logL} : The value of the complete log-likelihood.}
#' @export
#' @examples
#' # Data is taken from given reference:
#' hours <- c(2, 28, 67, 119, 179, 236, 282, 317, 348, 387, 3, 31, 69, 135,
#'           191, 241, 284, 318, 348, 392, 5, 31, 76, 144, 203, 257, 286,
#'           320, 350, 412, 8, 52, 78, 157, 211, 261, 298, 327, 360, 446,
#'           13, 53, 104, 160, 221, 264, 303, 328, 369, 21, 64, 113, 168,
#'           226, 278, 314, 328, 377)
#' state <- c(1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1,
#'          1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0,
#'          1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
#'          0, 1, 1, 1, 1, 1, 1)
#' post_dirichlet <- LearnBayes::rdirichlet(n = length(hours),
#'                                          par = rep(.1, 2))
#' mix_mod_em <- mixture_em_cpp(x = hours,
#'                              event = state,
#'                              post = post_dirichlet,
#'                              distribution = "weibull",
#'                              k = 2,
#'                              method = "EM",
#'                              n_iter = 150)
#'
mixture_em_cpp <- function(x, event, post, distribution = "weibull", k = 2L, method = "EM", n_iter = 100L, conv_limit = 1e-6) {
    .Call(`_weibulltools_mixture_em_cpp`, x, event, post, distribution, k, method, n_iter, conv_limit)
}

#' Computation of Johnson Ranks
#'
#' This function calculates the Johnson ranks which are used to estimate the
#' failure probabilities in case of (multiple) right censored data.
#'
#' @param f a numeric vector indicating the number of failed units for a
#'   specific realization of the lifetime characteristic.
#' @param n_out a numeric vector indicating the number of failed and censored
#'   units that have a shorter realization of lifetime characteristic as unit
#'   \emph{i}.
#' @param n an integer value indicating the sample size.
#'
#' @return A numeric vector containing the computed Johnson ranks.
#' @export
#' @examples
#'   defectives <- c(0, 1, 2, 0, 0, 0, 3, 0, 2, 0)
#'   n_out <- c(0, 2, 4, 8, 9, 11, 12, 16, 20, 22)
#'   n <- 23
#'   johnson_ranks <- calculate_ranks(f = defectives, n_out = n_out, n = n)
calculate_ranks <- function(f, n_out, n) {
    .Call(`_weibulltools_calculate_ranks`, f, n_out, n)
}

