% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_regression.R
\name{rank_regression.default}
\alias{rank_regression.default}
\title{Rank Regression for Parametric Lifetime Distributions}
\usage{
\method{rank_regression}{default}(
  x,
  y,
  status,
  distribution = c("weibull", "lognormal", "loglogistic", "normal", "logistic", "sev",
    "weibull3", "lognormal3", "loglogistic3"),
  conf_level = 0.95,
  ...
)
}
\arguments{
\item{x}{A numeric vector which consists of lifetime data. Lifetime data
could be every characteristic influencing the reliability of a product,
e.g. operating time (days/months in service), mileage (km, miles), load
cycles.}

\item{y}{A numeric vector which consists of estimated failure probabilities
regarding the lifetime data in \code{x}.}

\item{status}{A vector of binary data (0 or 1) indicating whether a unit is
a right censored observation (= 0) or a failure (= 1).}

\item{distribution}{Supposed distribution of the random variable.}

\item{conf_level}{Confidence level of the interval. If \code{distribution} is
\code{"weibull"} this must be one of \code{0.9}, \code{0.95} or \code{0.99}.}

\item{...}{Further arguments passed to or from other methods. Currently not used.}
}
\value{
Returns a list with classes \code{wt_model}, \code{wt_rank_regression} and
\code{wt_model_estimation} containing the following elements:
\itemize{
  \item \code{coefficients} : A named vector of estimated coefficients
    (parameters of the assumed distribution). \strong{Note}: The parameters
    are given in location-scale-parameterization.
  \item \code{confint} : Confidence intervals for parameters. If
    \code{distribution} is \code{"lognormal3"} or \code{"loglogistic3"} no
    confidence interval for the threshold parameter is computed.
  \item \code{varcov} : Provided, if \code{distribution} is not
    \code{"weibull"} or \code{"weibull3"}. Estimated heteroscedasticity-consistent
    variance-covariance matrix for the (log-)location-scale parameters.
  \item \code{shape_scale_coefficients} : Only included if
    \code{distribution} is \code{"weibull"} or \code{"weibull3"}
    (parameterization used in \code{\link[stats:Weibull]{stats::Weibull}}).
  \item \code{shape_scale_confint} : Only included if \code{distribution} is
    \code{"weibull"} or \code{"weibull3"}. Approximated confidence intervals
    for scale \eqn{\eta} and shape \eqn{\beta} (and threshold \eqn{\gamma})
    if \code{distribution} is \code{"weibull3"}.
  \item \code{r_squared} : Coefficient of determination.
  \item \code{data} : A tibble with columns \code{x}, \code{status} and \code{prob}.
  \item \code{distribution} : Specified distribution.
}
}
\description{
This function fits an \strong{x on y} regression to a linearized two- or
three-parameter lifetime distribution for complete and (multiple) right
censored data. The parameters are determined in the frequently used
(log-)location-scale parameterization.

For the Weibull, estimates are additionally transformed such that they are in
line with the parameterization provided by the \emph{stats} package
(see \link[stats]{Weibull}).
}
\details{
If \code{distribution} is \code{"weibull"} or \code{"weibull3"}, the approximated
confidence intervals for the parameters can only be estimated on the following
confidence levels (see 'References' \emph{(Mock, 1995)}):
\itemize{
  \item \code{conf_level} = 0.90,
  \item \code{conf_level} = 0.95,
  \item \code{conf_level} = 0.99.
}

If the distribution is not the Weibull, the confidence intervals of the
parameters are computed on the basis of a heteroscedasticity-consistent
covariance matrix. Here it should be said that there is no statistical foundation
to determine the standard errors of the parameters using \emph{Least Squares}
in context of \emph{Rank Regression}. For an accepted statistical method use
\link[=ml_estimation]{maximum likelihood}.
}
\examples{
# Vectors:
obs <- seq(10000, 100000, 10000)
status_1 <- c(0, 1, 1, 0, 0, 0, 1, 0, 1, 0)

cycles <- alloy$cycles
status_2 <- alloy$status

# Example 1 - Fitting a two-parametric weibull distribution:
tbl_john <- estimate_cdf(
  x = obs,
  status = status_1,
  method = "johnson"
)

rr <- rank_regression(
  x = tbl_john$x,
  y = tbl_john$prob,
  status = tbl_john$status,
  distribution = "weibull",
  conf_level = 0.90
)

# Example 2 - Fitting a three-parametric lognormal distribution:
tbl_kaplan <- estimate_cdf(
  x = cycles,
  status = status_2,
  method = "kaplan"
)

rr_2 <- rank_regression(
  x = tbl_kaplan$x,
  y = tbl_kaplan$prob,
  status = tbl_kaplan$status,
  distribution = "lognormal3"
)

}
\references{
\itemize{
    \item Mock, R., Methoden zur Datenhandhabung in
  Zuverlässigkeitsanalysen, vdf Hochschulverlag AG an der ETH Zürich, 1995
    \item Meeker, William Q; Escobar, Luis A., Statistical methods for
  reliability data, New York: Wiley series in probability and statistics, 1998}
}
\seealso{
\code{\link{rank_regression}}
}
